/*
 * Decompiled with CFR 0.152.
 */
package desenho.linhas;

import desenho.Elementar;
import desenho.ElementarEvento;
import desenho.FormaElementar;
import desenho.PontoElementar;
import desenho.formas.Forma;
import desenho.linhas.Linha;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;

public class PontoDeLinha
extends PontoElementar {
    private static final long serialVersionUID = -8695206427443411236L;
    public boolean IsTopOrBotton = true;
    private int posicao = -1;
    private transient Point down = new Point(0, 0);
    private transient boolean isMouseDown = false;
    private Forma em = null;
    private Linha linhaDona;
    private transient boolean dragging = false;
    private Forma overDraw = null;
    private int lado = 0;
    private boolean entrou = false;

    public PontoDeLinha(FormaElementar pai) {
        super(pai);
        if (pai instanceof Linha) {
            this.linhaDona = (Linha)pai;
        }
    }

    @Override
    public int getPosicao() {
        return this.posicao;
    }

    @Override
    public void setPosicao(int posicao) {
        this.posicao = posicao;
    }

    public boolean isEstaLigado() {
        return this.getEm() != null;
    }

    public Forma getEm() {
        return this.em;
    }

    public void setEm(Forma destino) {
        if (this.em != destino) {
            if (this.em != null) {
                this.PerformLigacao(this.em, false);
                this.em.menosLigacao(this);
                this.em = null;
            }
            if (destino != null && !destino.CanLiga(this)) {
                this.em = null;
                return;
            }
            this.em = destino;
            if (destino != null) {
                this.PerformLigacao(destino, true);
                this.em.maisLigacao(this);
            }
        }
    }

    public void SetEm(Forma destino) {
        this.em = destino;
        if (destino != null) {
            this.PerformLigacao(destino, true);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.isMouseDown = true;
        this.down = new Point(e.getX(), e.getY());
    }

    @Override
    public Linha getDono() {
        return this.linhaDona;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isMouseDown = false;
        this.dragging = false;
        if (this.IsTopOrBotton) {
            Elementar res = this.getMaster().CaptureBaseFromPoint(null, e.getPoint());
            if (res instanceof Forma) {
                res = res.ProcessaComposicao(e.getPoint());
                this.setEm((Forma)res);
                if (this.getEm() != null) {
                    this.getEm().PosicionePonto(this);
                    this.getDono().OrganizeLinha();
                }
            } else {
                this.setEm(null);
            }
        }
        this.getDono().reSetBounds();
        this.ReenquadreLinha();
        Rectangle rec = this.getBounds();
        rec.grow(5, 5);
        this.InvalidateArea(rec);
        this.ProcessaOverDraw(true);
        super.mouseReleased(e);
    }

    public boolean LigarA(Elementar res) {
        boolean sn = false;
        if (res instanceof Forma) {
            this.setEm((Forma)res);
            if (this.getEm() != null) {
                this.getEm().PosicionePonto(this);
                this.getDono().OrganizeLinha();
                sn = true;
            }
        }
        this.getDono().reSetBounds();
        this.ReenquadreLinha();
        Rectangle rec = this.getBounds();
        rec.grow(5, 5);
        this.InvalidateArea(rec);
        return sn;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        super.mouseDragged(e);
        int X = e.getX();
        int Y = e.getY();
        if (this.isMouseDown) {
            int movX = X - this.down.x;
            int movY = Y - this.down.y;
            if (movX != 0 || movY != 0) {
                this.DoMove(movX, movY);
                this.down.setLocation(e.getPoint());
                this.getDono().reSetBounds();
            }
            this.down.setLocation(e.getPoint());
            this.ProcessaOverDraw(false);
        }
    }

    public void ProcessaOverDraw(boolean zera) {
        if (this.IsTopOrBotton) {
            if (zera) {
                if (this.overDraw != null) {
                    this.overDraw.setOverMe(false);
                    this.overDraw = null;
                }
                return;
            }
            Elementar el = this.getMaster().CaptureBaseFromPoint(this, this.getCentro());
            if (el == null) {
                if (this.overDraw != null) {
                    this.overDraw.setOverMe(false);
                    this.overDraw = null;
                }
            } else {
                if (el.isComposto()) {
                    el = el.ProcessaComposicao(this.getCentro());
                }
                if (el instanceof Forma && el != this.overDraw) {
                    if (this.overDraw != null) {
                        this.overDraw.setOverMe(false);
                    }
                    this.overDraw = el;
                    this.overDraw.setOverMe(true);
                }
            }
        }
    }

    @Override
    public void mouseDblClicked(MouseEvent e) {
        super.mouseDblClicked(e);
        this.getDono().ReciveClick(this, true, e);
    }

    private void ReenquadreLinha() {
        int recuo = this.getRecuo();
        boolean ok = false;
        if (this.getLeft() < 0) {
            this.setLeft(0);
            ok = true;
        }
        if (this.getTop() < 0) {
            this.setTop(0);
            ok = true;
        }
        if (this.getLeft() + this.getWidth() > this.getMaster().getWidth()) {
            this.setLeft(this.getMaster().getWidth() - this.getWidth() - recuo);
            ok = true;
        }
        if (this.getTop() + this.getHeight() > this.getMaster().getHeight()) {
            this.setTop(this.getMaster().getHeight() - this.getHeight() - recuo);
            ok = true;
        }
        if (ok) {
            this.getDono().reSetBounds();
        }
    }

    @Override
    public void ReciveNotificacao(ElementarEvento evt) {
        int i = evt.getCod();
        Linha linha = this.getDono();
        switch (i) {
            case 2: {
                if (linha.isSelecionado()) break;
                Point pt = (Point)evt.getMsg();
                this.DoMove(pt.x, pt.y);
                this.meOrganizeLigacao();
                break;
            }
            case 3: {
                Point pt = (Point)evt.getMsg();
                this.DoMove(pt.x, pt.y);
                this.meOrganizeLigacao();
                break;
            }
            case 4: {
                this.ReposicioneAfterFormaResize((Forma)evt.getSender());
                break;
            }
            case 5: {
                this.SimplesmenteReposicione((Forma)evt.getSender());
                break;
            }
            case 6: {
                this.meOrganizeLigacao();
                break;
            }
            case 1: {
                if (this.getEm() != evt.getSender()) break;
                this.em = null;
                super.ReciveNotificacao(evt);
                this.meOrganizeLigacao();
                break;
            }
            default: {
                super.ReciveNotificacao(evt);
            }
        }
    }

    private void ReposicioneAfterFormaResize(Forma formaMovida) {
        boolean ok = false;
        Point area = this.getLocation();
        int recuo = -1;
        int corecuo = 1;
        int extremo1 = 0;
        int extremo2 = 0;
        int pos = 0;
        switch (this.getLado()) {
            case 0: {
                this.setLeft(formaMovida.getLeft() - this.getWidth() / 2 + recuo);
                extremo1 = formaMovida.getTop() - this.getWidth() / 2 + recuo;
                extremo2 = formaMovida.getTopHeight() - this.getHeight() + corecuo;
                pos = this.getTop();
                if (pos >= extremo1 && pos <= extremo2) break;
                if (pos < extremo1) {
                    this.setTop(extremo1);
                } else {
                    this.setTop(extremo2);
                }
                ok = true;
                break;
            }
            case 1: {
                this.setTop(formaMovida.getTop() - this.getWidth() / 2 + recuo);
                extremo1 = formaMovida.getLeft() - this.getWidth() / 2 + recuo;
                extremo2 = formaMovida.getLeftWidth() - this.getWidth() + corecuo;
                pos = this.getLeft();
                if (pos >= extremo1 && pos <= extremo2) break;
                if (pos < extremo1) {
                    this.setLeft(extremo1);
                } else {
                    this.setLeft(extremo2);
                }
                ok = true;
                break;
            }
            case 2: {
                this.setLeft(formaMovida.getLeftWidth() - this.getWidth() / 2 + corecuo);
                extremo1 = formaMovida.getTop() - this.getWidth() / 2 + recuo;
                extremo2 = formaMovida.getTopHeight() - this.getHeight() / 2 + corecuo;
                pos = this.getTop();
                if (pos >= extremo1 && pos <= extremo2) break;
                if (pos < extremo1) {
                    this.setTop(extremo1);
                } else {
                    this.setTop(extremo2);
                }
                ok = true;
                break;
            }
            case 3: {
                this.setTop(formaMovida.getTopHeight() - this.getHeight() / 2 + corecuo);
                extremo1 = formaMovida.getLeft() - this.getWidth() / 2 + recuo;
                extremo2 = formaMovida.getLeftWidth() - this.getWidth() / 2 + corecuo;
                pos = this.getLeft();
                if (pos >= extremo1 && pos <= extremo2) break;
                if (pos < extremo1) {
                    this.setLeft(extremo1);
                } else {
                    this.setLeft(extremo2);
                }
                ok = true;
            }
        }
        if (ok || area != this.getLocation()) {
            this.meOrganizeLigacao();
        }
    }

    public void SimplesmenteReposicione(Forma base) {
        base.PosicionePonto(this);
        this.meOrganizeLigacao();
    }

    protected void meOrganizeLigacao() {
        this.getDono().OrganizeLinha();
        this.getDono().reSetBounds();
    }

    public int getLado() {
        return this.lado;
    }

    public void setLado(int lado) {
        this.lado = lado;
    }

    @Override
    public void DoPaint(Graphics2D g) {
        super.DoPaint(g);
        if (this.IsTopOrBotton && !this.isEstaLigado()) {
            Paint bkpP = g.getPaint();
            Rectangle rec = this.getBounds();
            if (this.getMaster().IsMultSelecionado() && this.getDono().isSelecionado()) {
                g.setPaint(this.getBackColor());
            } else {
                g.setPaint(Color.red);
            }
            g.fillOval(rec.x, rec.y, rec.width, rec.height);
            g.drawString("x", this.getCentro().x, this.getCentro().y);
            g.setPaint(bkpP);
        }
        if (this.entrou) {
            Rectangle rec = this.getBounds();
            int x = rec.width / 2;
            int y = rec.height / 2;
            rec.grow(x + 1, y + 1);
            Stroke bkp = g.getStroke();
            Paint bkpP = g.getPaint();
            g.setStroke(new BasicStroke(1.0f, 1, 1, 2.0f, new float[]{2.0f, 2.0f}, 0.0f));
            g.setPaint(Color.gray);
            g.drawOval(rec.x, rec.y, rec.width, rec.height);
            g.setStroke(bkp);
            g.setPaint(bkpP);
        }
        if (this.dragging && this.getMaster().getEditor().isMostrarDimensoesAoMover()) {
            Stroke bkp = g.getStroke();
            Paint bkpP = g.getPaint();
            g.setStroke(new BasicStroke(1.0f, 1, 1, 2.0f, new float[]{2.0f, 2.0f}, 0.0f));
            g.setPaint(Color.gray);
            g.drawLine(0, this.getCentro().y, this.getMaster().getWidth(), this.getCentro().y);
            g.drawLine(this.getCentro().x, 0, this.getCentro().x, this.getMaster().getHeight());
            Font bkpf = g.getFont();
            g.setFont(new Font(bkpf.getName(), 2, bkpf.getSize() - 2));
            g.drawString("[" + String.valueOf(this.getLeft()) + "," + String.valueOf(this.getTop()) + "]", this.getWidth() + this.getLeft() + 2, this.getTop() - 2);
            g.setFont(bkpf);
            g.setStroke(bkp);
            g.setPaint(bkpP);
        }
    }

    boolean ForceIsMe(Point p) {
        return this.getBounds().contains(p);
    }

    @Override
    public boolean IsMe(Point p) {
        if (this.linhaDona.isSelecionado()) {
            if (!this.isVisible()) {
                return super.IsMe(p);
            }
            Rectangle r = this.getBounds();
            int x = r.width / 2;
            int y = r.height / 2;
            r.grow(x, y);
            return r.contains(p);
        }
        return super.IsMe(p);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        super.mouseEntered(e);
        this.entrou = true;
        Rectangle r = this.getBounds();
        int x = r.width / 2;
        int y = r.height / 2;
        r.grow(x + 2, y + 2);
        this.InvalidateArea(r);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        this.entrou = false;
        Rectangle r = this.getBounds();
        int x = r.width / 2;
        int y = r.height / 2;
        r.grow(x + 2, y + 2);
        this.InvalidateArea(r);
    }
}

