<?php

use Facebook\WebDriver\Remote\DesiredCapabilities;
use Facebook\WebDriver\Remote\RemoteWebDriver;
use Facebook\WebDriver\Remote\RemoteWebElement;
use Facebook\WebDriver\WebDriverBy;
use Facebook\WebDriver\WebDriverKeys;
use PHPUnit\Framework\TestCase;

class RegistroTest extends TestCase
{
    public function testQuandoRegistrarNovoUsuarioDeveRedirecionarParaListaDeSeries()
    {
        // Arrange
        $host = 'http://localhost:4444/wd/hub';
        $driver = RemoteWebDriver::create($host, DesiredCapabilities::chrome());
        $driver->get('http://0.0.0.0:8080/novo-usuario');

        // Act
        $inputNome = $driver->findElement(WebDriverBy::id('name'));
        $inputEmail = $driver->findElement(WebDriverBy::id('email'));
        $inputSenha = $driver->findElement(WebDriverBy::id('password'));

        $inputNome->sendKeys('Nome Teste');
        $inputEmail->sendKeys(md5(time()) . '@example.com');
        $inputSenha->sendKeys('123');

        $inputSenha->submit();

        // Assert
        self::assertSame('http://0.0.0.0:8080/series', $driver->getCurrentURL());
        self::assertInstanceOf(
            RemoteWebElement::class,
            $driver->findElement(WebDriverBy::linkText('Sair'))
        );
    }
}
