/*
 * Decompiled with CFR 0.152.
 */
package controlador.apoios;

import controlador.Diagrama;
import controlador.Editor;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;

public class Historico {
    private final Editor master;
    private ArrayList<HistDiagrama> lista = new ArrayList();
    private HistDiagrama atual = null;
    private ArrayList<Diagrama> listaDiagramas = new ArrayList();

    public Historico(Editor aThis) {
        this.master = aThis;
    }

    private HistDiagrama updateAtual(Diagrama diagramaAtual) {
        if (this.atual == null || !this.atual.isMe(diagramaAtual)) {
            this.atual = this.getByDiagrama(diagramaAtual);
        }
        return this.atual;
    }

    private HistDiagrama getByDiagrama(Diagrama mo) {
        for (HistDiagrama hm : this.lista) {
            if (!hm.isMe(mo)) continue;
            return hm;
        }
        return null;
    }

    public ArrayList<String> getStrDiagramas() {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        for (Diagrama hm : this.getDiagramas()) {
            String tmp = "[" + Integer.toString(++i) + "] " + hm.getNomeFormatado();
            res.add(tmp);
        }
        return res;
    }

    public ArrayList<Diagrama> getDiagramas() {
        if (this.listaDiagramas != null) {
            return this.listaDiagramas;
        }
        ArrayList<Diagrama> res = new ArrayList<Diagrama>();
        this.lista.stream().forEach(hm -> res.add(hm.diagrama));
        this.listaDiagramas = res;
        return res;
    }

    public boolean removeDiagrama(Diagrama mo, Diagrama noLugar) {
        this.listaDiagramas = null;
        HistDiagrama hm = this.getByDiagrama(mo);
        boolean re = this.lista.remove(hm);
        if (noLugar == null) {
            this.atual = null;
        } else {
            this.updateAtual(noLugar);
        }
        return re;
    }

    public void add(Diagrama mo) {
        this.listaDiagramas = null;
        this.lista.add(new HistDiagrama(mo));
    }

    public void add(Diagrama mo, int index) {
        this.listaDiagramas = null;
        this.lista.add(index, new HistDiagrama(mo));
    }

    public Diagrama desfazer(Diagrama diagramaAtual) {
        this.listaDiagramas = null;
        HistDiagrama hm = this.updateAtual(diagramaAtual);
        if (hm == null) {
            return null;
        }
        return hm.desfazer();
    }

    public Diagrama refazer(Diagrama diagramaAtual) {
        this.listaDiagramas = null;
        HistDiagrama hm = this.updateAtual(diagramaAtual);
        if (hm == null) {
            return null;
        }
        return hm.refazer();
    }

    public boolean podeDesfazer(Diagrama diagramaAtual) {
        HistDiagrama hm = this.updateAtual(diagramaAtual);
        if (hm == null) {
            return false;
        }
        return hm.podeDesfazer();
    }

    public boolean podeRefazer(Diagrama diagramaAtual) {
        HistDiagrama hm = this.updateAtual(diagramaAtual);
        if (hm == null) {
            return false;
        }
        return hm.podeRefazer();
    }

    public void append(Diagrama diagramaAtual) {
        this.listaDiagramas = null;
        HistDiagrama hm = this.updateAtual(diagramaAtual);
        if (hm == null) {
            return;
        }
        hm.Append(diagramaAtual);
    }

    public void removeAll() {
        this.lista.clear();
    }

    class HistDiagrama {
        int posicao = 0;
        final int MAX = 500;
        Diagrama diagrama;
        ArrayList<ByteArrayOutputStream> diagramas = new ArrayList();

        public HistDiagrama(Diagrama diagrama) {
            this.diagrama = diagrama;
            this.diagramas.add(Diagrama.SaveToStream(diagrama));
        }

        public boolean isMe(Diagrama mod) {
            return this.diagrama == mod;
        }

        public boolean podeDesfazer() {
            return this.posicao > 0;
        }

        public boolean podeRefazer() {
            return this.posicao < this.diagramas.size() - 1;
        }

        public Diagrama desfazer() {
            if (this.podeDesfazer()) {
                --this.posicao;
                this.LoadDiagrama();
                return this.diagrama;
            }
            return null;
        }

        public Diagrama refazer() {
            if (this.podeRefazer()) {
                ++this.posicao;
                this.LoadDiagrama();
                return this.diagrama;
            }
            return null;
        }

        private void LoadDiagrama() {
            String tmpNome = this.diagrama.getNome();
            String tmpArq = this.diagrama.getArquivo();
            this.diagrama = Diagrama.LoadFromStream(this.diagramas.get(this.posicao));
            this.diagrama.SetNome(tmpNome);
            this.diagrama.setArquivo(tmpArq);
            this.diagrama.setMaster(Historico.this.master);
            this.diagrama.setMudou(true);
        }

        public synchronized void Append(Diagrama mo) {
            ByteArrayOutputStream res = Diagrama.SaveToStream(mo);
            if (res == null) {
                return;
            }
            ++this.posicao;
            this.diagramas.add(this.posicao, res);
            while (this.diagramas.size() - 1 > this.posicao) {
                this.diagramas.remove(this.diagramas.size() - 1);
            }
            if (this.posicao > 500) {
                this.diagramas.remove(0);
                --this.posicao;
            }
        }
    }
}

