/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.theory;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;
import org.jfugue.provider.ChordProviderFactory;
import org.jfugue.theory.Intervals;
import org.jfugue.theory.Key;
import org.jfugue.theory.Note;

public class Chord
implements PatternProducer {
    public static Map<String, Intervals> chordMap = new TreeMap<String, Intervals>(new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int result = this.compareLength(s1, s2);
            if (result == 0) {
                result = s1.compareTo(s2);
            }
            return result;
        }

        private int compareLength(String s1, String s2) {
            if (s1.length() < s2.length()) {
                return 1;
            }
            if (s1.length() > s2.length()) {
                return -1;
            }
            return 0;
        }
    });
    public static Map<String, String> humanReadableMap;
    private Note rootNote;
    private Intervals intervals;
    private int inversion;
    public static final Intervals MAJOR_INTERVALS;
    public static final Intervals MINOR_INTERVALS;
    public static final Intervals DIMINISHED_INTERVALS;
    public static final Intervals MAJOR_SEVENTH_INTERVALS;
    public static final Intervals MINOR_SEVENTH_INTERVALS;
    public static final Intervals DIMINISHED_SEVENTH_INTERVALS;
    public static final Intervals MAJOR_SEVENTH_SIXTH_INTERVALS;
    public static final Intervals MINOR_SEVENTH_SIXTH_INTERVALS;

    public static String[] getChordNames() {
        return chordMap.keySet().toArray(new String[0]);
    }

    public static void addChord(String name, String intervalPattern) {
        Chord.addChord(name, new Intervals(intervalPattern));
    }

    public static void addChord(String name, Intervals intervalPattern) {
        chordMap.put(name, intervalPattern);
    }

    public static Intervals getIntervals(String name) {
        return chordMap.get(name);
    }

    public static void removeChord(String name) {
        chordMap.remove(name);
    }

    public static String getChordType(Intervals intervals) {
        for (Map.Entry<String, Intervals> entry : chordMap.entrySet()) {
            if (!intervals.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void putHumanReadable(String chordName, String humanReadableName) {
        humanReadableMap.put(chordName, humanReadableName);
    }

    public static String getHumanReadableName(String chordName) {
        if (humanReadableMap.containsKey(chordName)) {
            return humanReadableMap.get(chordName);
        }
        return chordName;
    }

    public static boolean isValidChord(String candidateChordMusicString) {
        String musicString = candidateChordMusicString.toUpperCase();
        for (String chordName : chordMap.keySet()) {
            if (!musicString.contains(chordName)) continue;
            int index = musicString.indexOf(chordName);
            String possibleNote = musicString.substring(0, index);
            String qualifiers = musicString.substring(index + chordName.length() - 1, musicString.length() - 1);
            if (!Note.isValidNote(possibleNote) || !Note.isValidQualifier(qualifiers)) continue;
            return true;
        }
        return false;
    }

    public Chord(String s) {
        this(ChordProviderFactory.getChordProvider().createChord(s));
    }

    public Chord(Chord chord) {
        this.rootNote = chord.getRoot();
        this.intervals = chord.getIntervals();
        this.inversion = chord.getInversion();
    }

    public Chord(Note root, Intervals intervals) {
        this.rootNote = root;
        this.intervals = intervals;
    }

    public Chord(Key key) {
        this.rootNote = key.getRoot();
        this.intervals = key.getScale().getIntervals();
    }

    public static Chord fromNotes(String noteString) {
        return Chord.fromNotes(noteString.split(" "));
    }

    public static Chord fromNotes(String[] noteStrings) {
        ArrayList<Note> notes = new ArrayList<Note>();
        for (String noteString : noteStrings) {
            notes.add(new Note(noteString));
        }
        return Chord.fromNotes(notes.toArray(new Note[notes.size()]));
    }

    public static Chord fromNotes(Note[] notes) {
        return new Chord(Chord.getChordFromNotes(notes));
    }

    private static Note[] flattenNotesByPositionInOctave(Note[] notes) {
        HashMap<Integer, Note> noteMap = new HashMap<Integer, Note>();
        ArrayList<Integer> noteOrder = new ArrayList<Integer>();
        for (Note note : notes) {
            byte positionInOctave = note.getPositionInOctave();
            if (noteMap.containsKey(positionInOctave)) continue;
            noteMap.put(Integer.valueOf(positionInOctave), note);
            noteOrder.add(Integer.valueOf(positionInOctave));
        }
        Note[] retVal = new Note[noteMap.size()];
        int counter = 0;
        for (Integer positionInOctave : noteOrder) {
            retVal[counter++] = (Note)noteMap.get(positionInOctave);
        }
        return retVal;
    }

    private static String getChordFromNotes(Note[] notes) {
        int i;
        boolean returnNonOctaveNotes = false;
        Note.sortNotesBy(notes, new Note.SortingCallback(){

            @Override
            public int getSortingValue(Note note) {
                return note.getValue();
            }
        });
        if (notes[notes.length - 1].getValue() - notes[0].getValue() > 12) {
            returnNonOctaveNotes = true;
        }
        Note bassNote = notes[0];
        Note.sortNotesBy(notes, new Note.SortingCallback(){

            @Override
            public int getSortingValue(Note note) {
                return note.getPositionInOctave();
            }
        });
        notes = Chord.flattenNotesByPositionInOctave(notes);
        String[] possibleChords = new String[notes.length];
        for (i = 0; i < notes.length; ++i) {
            Note[] notesToCheck = new Note[notes.length];
            for (int u = 0; u < notes.length; ++u) {
                notesToCheck[u] = notes[(i + u) % notes.length];
            }
            possibleChords[i] = Chord.getChordType(Intervals.createIntervalsFromNotes(notesToCheck));
        }
        for (i = 0; i < possibleChords.length; ++i) {
            if (possibleChords[i] == null) continue;
            StringBuilder sb = new StringBuilder();
            if (returnNonOctaveNotes) {
                sb.append(Note.getToneStringWithoutOctave(notes[i].getValue()));
            } else {
                sb.append(notes[i]);
            }
            sb.append(possibleChords[i]);
            if (!bassNote.equals(notes[i])) {
                sb.append("^");
                sb.append(bassNote);
            }
            return sb.toString();
        }
        return null;
    }

    public Note getRoot() {
        return this.rootNote;
    }

    public Intervals getIntervals() {
        return this.intervals;
    }

    public int getInversion() {
        return this.inversion;
    }

    public Chord setInversion(int nth) {
        this.inversion = nth;
        return this;
    }

    public Chord setBassNote(String newBass) {
        return this.setBassNote(new Note(newBass));
    }

    public Chord setBassNote(Note newBass) {
        if (this.rootNote == null) {
            return this;
        }
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (newBass.getValue() % 12 != (this.rootNote.getValue() + Intervals.getHalfsteps(this.intervals.getNthInterval(i))) % 12) continue;
            this.inversion = i;
        }
        return this;
    }

    public Note getBassNote() {
        int bassNoteValue = this.rootNote.getValue() - 12 + Intervals.getHalfsteps(this.intervals.getNthInterval(this.inversion));
        Note r = new Note(Note.NOTE_NAMES_COMMON[bassNoteValue % 12]).useSameExplicitOctaveSettingAs(this.getRoot());
        return r;
    }

    public Chord setOctave(int octave) {
        this.rootNote.setValue((byte)(this.rootNote.getPositionInOctave() + octave * 12));
        return this;
    }

    public Note[] getNotes() {
        int i;
        int[] halfsteps = this.intervals.toHalfstepArray();
        Note[] retVal = new Note[halfsteps.length];
        retVal[0] = new Note(this.getRoot());
        for (i = 0; i < halfsteps.length - 1; ++i) {
            retVal[i + 1] = new Note(retVal[i].getValue() + halfsteps[i + 1] - halfsteps[i]).setFirstNote(false).setMelodicNote(false).setHarmonicNote(true).useSameDurationAs(this.getRoot()).useSameExplicitOctaveSettingAs(this.getRoot());
            if (this.getRoot().isOctaveExplicitlySet()) continue;
            retVal[i + 1].setOriginalString(Note.getToneStringWithoutOctave((byte)(retVal[i].getValue() + halfsteps[i + 1] - halfsteps[i])));
        }
        for (i = 0; i < this.getInversion(); ++i) {
            if (i >= retVal.length) continue;
            retVal[i].setValue((byte)(retVal[i].getValue() + 12));
        }
        Note[] retVal2 = new Note[retVal.length];
        for (int i2 = 0; i2 < retVal.length; ++i2) {
            retVal2[i2] = retVal[(i2 + this.getInversion()) % retVal.length];
        }
        return retVal2;
    }

    private String insertChordNameIntoNote(Note note, String chordName) {
        StringBuilder buddy = new StringBuilder();
        buddy.append(note.getToneString());
        buddy.append(chordName);
        if (note.isDurationExplicitlySet()) {
            buddy.append(Note.getDurationString(note.getDuration()));
        }
        buddy.append(note.getVelocityString());
        return buddy.toString();
    }

    public String getChordType() {
        for (Map.Entry<String, Intervals> entry : chordMap.entrySet()) {
            if (!this.getIntervals().equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static int getInversionFromChordString(String chordString) {
        int counter = 0;
        for (char c : chordString.toCharArray()) {
            if (c != '^') continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public Pattern getPattern() {
        Pattern pattern = new Pattern();
        boolean foundChord = false;
        String chordName = this.getChordType();
        if (chordName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.insertChordNameIntoNote(this.rootNote, chordName));
            for (int i = 0; i < this.getInversion(); ++i) {
                sb.append("^");
            }
            pattern.add(sb.toString());
            foundChord = true;
        }
        if (!foundChord) {
            return this.getPatternWithNotes();
        }
        return pattern;
    }

    public Pattern getPatternWithNotes() {
        StringBuilder buddy = new StringBuilder();
        Note[] notes = this.getNotes();
        for (int i = 0; i < notes.length - 1; ++i) {
            buddy.append(notes[i].getPattern());
            buddy.append("+");
        }
        buddy.append(notes[notes.length - 1]);
        return new Pattern(buddy.toString());
    }

    public Pattern getPatternWithNotesExceptRoot() {
        StringBuilder buddy = new StringBuilder();
        Note[] notes = this.getNotes();
        for (int i = 0; i < notes.length; ++i) {
            if (notes[i].getPositionInOctave() == this.getRoot().getPositionInOctave()) continue;
            buddy.append(notes[i].getPattern());
            buddy.append("+");
        }
        buddy.deleteCharAt(buddy.length() - 1);
        return new Pattern(buddy.toString());
    }

    public Pattern getPatternWithNotesExceptBass() {
        StringBuilder buddy = new StringBuilder();
        Note[] notes = this.getNotes();
        for (int i = 0; i < notes.length - 1; ++i) {
            if (notes[i].getValue() % 12 == this.getBassNote().getValue() % 12) continue;
            buddy.append(notes[i].getPattern());
            buddy.append("+");
        }
        buddy.append(notes[notes.length - 1]);
        return new Pattern(buddy.toString());
    }

    public boolean isMajor() {
        return this.intervals.equals(MAJOR_INTERVALS);
    }

    public boolean isMinor() {
        return this.intervals.equals(MINOR_INTERVALS);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Chord)) {
            return false;
        }
        Chord c2 = (Chord)o;
        return c2.rootNote.equals(this.rootNote) && c2.intervals.equals(this.intervals) && c2.inversion == this.inversion;
    }

    public String toString() {
        return this.getPattern().toString();
    }

    public String toNoteString() {
        StringBuilder buddy = new StringBuilder();
        buddy.append("(");
        for (Note note : this.getNotes()) {
            buddy.append(note.toString());
            buddy.append("+");
        }
        buddy.deleteCharAt(buddy.length() - 1);
        buddy.append(")");
        return buddy.toString();
    }

    public String toHumanReadableString() {
        return this.rootNote + Chord.getHumanReadableName(this.getChordType());
    }

    public String toDebugString() {
        StringBuilder buddy = new StringBuilder();
        int counter = 0;
        for (Note note : this.getNotes()) {
            buddy.append("Note ").append(counter++).append(": ").append(note.toDebugString()).append("\n");
        }
        buddy.append("Chord Intervals = " + this.getIntervals().toString()).append("\n");
        buddy.append("Inversion = ").append(this.inversion);
        return buddy.toString();
    }

    static {
        chordMap.put("MAJ", new Intervals("1 3 5"));
        chordMap.put("MAJ6", new Intervals("1 3 5 6"));
        chordMap.put("MAJ7", new Intervals("1 3 5 7"));
        chordMap.put("MAJ9", new Intervals("1 3 5 7 9"));
        chordMap.put("ADD9", new Intervals("1 3 5 9"));
        chordMap.put("MAJ6%9", new Intervals("1 3 5 6 9"));
        chordMap.put("MAJ7%6", new Intervals("1 3 5 6 7"));
        chordMap.put("MAJ13", new Intervals("1 3 5 7 9 13"));
        chordMap.put("MIN", new Intervals("1 b3 5"));
        chordMap.put("MIN6", new Intervals("1 b3 5 6"));
        chordMap.put("MIN7", new Intervals("1 b3 5 b7"));
        chordMap.put("MIN9", new Intervals("1 b3 5 b7 9"));
        chordMap.put("MIN11", new Intervals("1 b3 5 b7 9 11"));
        chordMap.put("MIN7%11", new Intervals("1 b3 5 b7 11"));
        chordMap.put("MINADD9", new Intervals("1 b3 5 9"));
        chordMap.put("MIN6%9", new Intervals("1 b3 5 6"));
        chordMap.put("MINMAJ7", new Intervals("1 b3 5 7"));
        chordMap.put("MINMAJ9", new Intervals("1 b3 5 7 9"));
        chordMap.put("DOM7", new Intervals("1 3 5 b7"));
        chordMap.put("DOM7%6", new Intervals("1 3 5 6 b7"));
        chordMap.put("DOM7%11", new Intervals("1 3 5 b7 11"));
        chordMap.put("DOM7SUS", new Intervals("1 4 5 b7"));
        chordMap.put("DOM7%6SUS", new Intervals("1 4 5 6 b7"));
        chordMap.put("DOM9", new Intervals("1 3 5 b7 9"));
        chordMap.put("DOM11", new Intervals("1 3 5 b7 9 11"));
        chordMap.put("DOM13", new Intervals("1 3 5 b7 9 13"));
        chordMap.put("DOM13SUS", new Intervals("1 3 5 b7 11 13"));
        chordMap.put("DOM7%6%11", new Intervals("1 3 5 b7 9 11 13"));
        chordMap.put("AUG", new Intervals("1 3 #5"));
        chordMap.put("AUG7", new Intervals("1 3 #5 b7"));
        chordMap.put("DIM", new Intervals("1 b3 b5"));
        chordMap.put("DIM7", new Intervals("1 b3 b5 6"));
        chordMap.put("SUS4", new Intervals("1 4 5"));
        chordMap.put("SUS2", new Intervals("1 2 5"));
        humanReadableMap = new HashMap<String, String>();
        humanReadableMap.put("MAJ6%9", "6/9");
        humanReadableMap.put("MAJ7%6", "7/6");
        MAJOR_INTERVALS = new Intervals("1 3 5");
        MINOR_INTERVALS = new Intervals("1 b3 5");
        DIMINISHED_INTERVALS = new Intervals("1 b3 b5");
        MAJOR_SEVENTH_INTERVALS = new Intervals("1 3 5 7");
        MINOR_SEVENTH_INTERVALS = new Intervals("1 b3 5 b7");
        DIMINISHED_SEVENTH_INTERVALS = new Intervals("1 b3 b5 6");
        MAJOR_SEVENTH_SIXTH_INTERVALS = new Intervals("1 3 5 6 7");
        MINOR_SEVENTH_SIXTH_INTERVALS = new Intervals("1 3 5 6 7");
    }
}

