package br.com.alura.forum.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class Curso {

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Long id;
	private String nome;

	@ManyToOne
	private Subcategoria subcategoria;

	// construtor default exigido pela JPA
	protected Curso() {
	}

	public Curso(String nome, Subcategoria subcategoria) {
		this.nome = nome;
		this.subcategoria = subcategoria;
	}

	// getters
	public Long getId() {
		return id;
	}

	public String getNome() {
		return nome;
	}

	public Subcategoria getSubcategoria() {
		return subcategoria;
	}

}
