package br.com.alura.forum.controller.form;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import br.com.alura.forum.model.Curso;
import br.com.alura.forum.model.Topico;
import br.com.alura.forum.model.Usuario;
import br.com.alura.forum.repository.CursoRepository;

public class NovoTopicoForm {

	@NotNull
	@NotEmpty
	private String titulo;

	@NotNull
	@NotEmpty
	private String mensagem;
	
	@NotNull
	@NotEmpty
	private String nomeCurso;

	public Topico getTopico(CursoRepository cursoRepository, Usuario logado) {
		Curso curso = cursoRepository.findByNome(this.nomeCurso);
		return new Topico(titulo, mensagem, curso, logado);
	}

	// setters
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}

	public void setMensagem(String mensagem) {
		this.mensagem = mensagem;
	}

	public void setNomeCurso(String nomeCurso) {
		this.nomeCurso = nomeCurso;
	}

}
