/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.temporal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfugue.parser.Parser;
import org.jfugue.parser.ParserListener;
import org.jfugue.temporal.TemporalEvent;
import org.jfugue.temporal.TemporalEventManager;
import org.jfugue.temporal.TemporalEvents;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;

public class TemporalPLP
extends Parser
implements ParserListener {
    private TemporalEventManager eventManager;
    private TemporalEvents events = new TemporalEvents();

    public TemporalPLP() {
        this.eventManager = new TemporalEventManager();
    }

    public Map<Long, List<TemporalEvent>> getTimeToEventMap() {
        return this.eventManager.getTimeToEventMap();
    }

    @Override
    public void beforeParsingStarts() {
        this.eventManager.reset();
    }

    @Override
    public void afterParsingFinished() {
        this.eventManager.finish();
    }

    @Override
    public void onTrackChanged(byte track) {
        this.eventManager.setCurrentTrack(track);
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.TrackEvent(track));
    }

    @Override
    public void onLayerChanged(byte layer) {
        this.eventManager.setCurrentLayer(layer);
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.LayerEvent(layer));
    }

    @Override
    public void onInstrumentParsed(byte instrument) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.InstrumentEvent(instrument));
    }

    @Override
    public void onTempoChanged(int tempoBPM) {
        this.eventManager.setTempo(tempoBPM);
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.TempoEvent(tempoBPM));
    }

    @Override
    public void onKeySignatureParsed(byte key, byte scale) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.KeySignatureEvent(key, scale));
    }

    @Override
    public void onTimeSignatureParsed(byte numerator, byte powerOfTwo) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.TimeSignatureEvent(numerator, powerOfTwo));
    }

    @Override
    public void onBarLineParsed(long time) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.BarEvent(time));
    }

    @Override
    public void onTrackBeatTimeBookmarked(String timeBookmarkID) {
        this.eventManager.addTrackTickTimeBookmark(timeBookmarkID);
    }

    @Override
    public void onTrackBeatTimeBookmarkRequested(String timeBookmarkID) {
        double time = this.eventManager.getTrackBeatTimeBookmark(timeBookmarkID);
        this.eventManager.setTrackBeatTime(time);
    }

    @Override
    public void onTrackBeatTimeRequested(double time) {
        this.eventManager.setTrackBeatTime(time);
    }

    @Override
    public void onPitchWheelParsed(byte lsb, byte msb) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.PitchWheelEvent(lsb, msb));
    }

    @Override
    public void onChannelPressureParsed(byte pressure) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.ChannelPressureEvent(pressure));
    }

    @Override
    public void onPolyphonicPressureParsed(byte key, byte pressure) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.PolyphonicPressureEvent(key, pressure));
    }

    @Override
    public void onSystemExclusiveParsed(byte ... bytes) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.SystemExclusiveEvent(bytes));
    }

    @Override
    public void onControllerEventParsed(byte controller, byte value) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.ControllerEvent(controller, value));
    }

    @Override
    public void onLyricParsed(String lyric) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.LyricEvent(lyric));
    }

    @Override
    public void onMarkerParsed(String marker) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.MarkerEvent(marker));
    }

    @Override
    public void onFunctionParsed(String id, Object message) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.UserEvent(id, message));
    }

    @Override
    public void onNotePressed(Note note) {
    }

    @Override
    public void onNoteReleased(Note note) {
    }

    @Override
    public void onNoteParsed(Note note) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.NoteEvent(note));
    }

    @Override
    public void onChordParsed(Chord chord) {
        TemporalEvents temporalEvents = this.events;
        temporalEvents.getClass();
        this.eventManager.addRealTimeEvent(temporalEvents.new TemporalEvents.ChordEvent(chord));
    }

    private void delay(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parse() {
        this.fireBeforeParsingStarts();
        long oldTime = 0L;
        Set<Long> times = this.eventManager.getTimeToEventMap().keySet();
        for (long time : times) {
            this.delay(time - oldTime);
            oldTime = time;
            for (TemporalEvent event : this.eventManager.getTimeToEventMap().get(time)) {
                event.execute(this);
            }
        }
        this.fireAfterParsingFinished();
    }
}

