/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import org.jfugue.midi.MidiTools;
import org.staccato.StaccatoParserContext;
import org.staccato.SubparserFunction;

public class PitchWheelFunction
implements SubparserFunction {
    private static PitchWheelFunction instance;
    public static String[] NAMES;

    public static PitchWheelFunction getInstance() {
        if (instance == null) {
            instance = new PitchWheelFunction();
        }
        return instance;
    }

    private PitchWheelFunction() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public void apply(String parameters, StaccatoParserContext context) {
        String[] params = parameters.split(",");
        if (params.length == 2) {
            context.getParser().firePitchWheelParsed(Byte.parseByte(params[0].trim()), Byte.parseByte(params[1].trim()));
        } else if (params.length == 1) {
            int pitch = Integer.parseInt(params[0]);
            context.getParser().firePitchWheelParsed(MidiTools.getLSB(pitch), MidiTools.getMSB(pitch));
        }
    }

    static {
        NAMES = new String[]{"PW", "PITCHWHEEL", "PB", "PITCHBEND"};
    }
}

