/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import org.jfugue.midi.MidiDictionary;
import org.jfugue.parser.Parser;
import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.DefaultNoteSettingsManager;

public final class MusicXmlParser
extends Parser {
    private Builder xomBuilder;
    private Document xomDoc;
    private byte curVelocity = DefaultNoteSettingsManager.getInstance().getDefaultOnVelocity();
    private byte beatsPerMeasure = 1;
    private byte divisionsPerBeat = 1;
    private int currentVoice = -1;
    private byte currentLayer;
    private KeySignature keySignature = new KeySignature(0, 0);
    private byte nextVoice = 0;
    private VoiceDefinition[] voices;
    private PartContext currentPart;
    private static final Comparator<String> CHORD_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int result = this.compareLength(s1, s2);
            if (result == 0) {
                result = s1.compareTo(s2);
            }
            return result;
        }

        private int compareLength(String s1, String s2) {
            if (s1.length() < s2.length()) {
                return 1;
            }
            if (s1.length() > s2.length()) {
                return -1;
            }
            return 0;
        }
    };
    public static Map<String, String> XMLtoJFchordMap = new TreeMap<String, String>(CHORD_COMPARATOR);

    public MusicXmlParser() throws ParserConfigurationException {
        this.xomBuilder = new Builder();
        this.voices = new VoiceDefinition[32];
    }

    public void parse(String musicXmlString) throws ValidityException, ParsingException, IOException {
        this.parse(this.xomBuilder.build(musicXmlString, (String)null));
    }

    public void parse(File inputFile) throws ValidityException, ParsingException, IOException {
        this.parse(this.xomBuilder.build(inputFile));
    }

    public void parse(FileInputStream inputStream) throws ValidityException, ParsingException, IOException {
        this.parse(this.xomBuilder.build((InputStream)inputStream));
    }

    public void parse(Reader reader) throws ValidityException, ParsingException, IOException {
        this.parse(this.xomBuilder.build(reader));
    }

    private void parse(Document document) {
        this.xomDoc = document;
        this.parse();
    }

    public void parse() {
        this.fireBeforeParsingStarts();
        Element root = this.xomDoc.getRootElement();
        if (root.getQualifiedName().equalsIgnoreCase("score-timewise")) {
            this.parseTimeWise(root);
        } else if (root.getQualifiedName().equalsIgnoreCase("score-partwise")) {
            this.parsePartWise(root);
        }
    }

    private void parsePartWise(Element root) {
        Element partlist = root.getFirstChildElement("part-list");
        Elements parts = partlist.getChildElements();
        Map<String, PartContext> partHeaders = this.parsePartList(parts);
        parts = root.getChildElements("part");
        for (int childId = 0; childId < parts.size(); ++childId) {
            Element partElement = parts.get(childId);
            String partId = partElement.getAttribute("id").getValue();
            this.switchPart(partHeaders, partId, childId);
            Elements measures = partElement.getChildElements("measure");
            for (int measure = 0; measure < measures.size(); ++measure) {
                this.parseMusicData(childId, partId, partHeaders, measures.get(measure));
                this.fireBarLineParsed(0L);
            }
        }
    }

    private void parseTimeWise(Element root) {
        Element partlist = root.getFirstChildElement("part-list");
        Elements scoreParts = partlist.getChildElements();
        Map<String, PartContext> partHeaders = this.parsePartList(scoreParts);
        Elements measures = root.getChildElements("measure");
        for (int measureIndex = 0; measureIndex < measures.size(); ++measureIndex) {
            Element measureElement = measures.get(measureIndex);
            Elements parts = measureElement.getChildElements("part");
            for (int partIndex = 0; partIndex < parts.size(); ++partIndex) {
                Element partElement = parts.get(partIndex);
                String partId = partElement.getAttribute("id").getValue();
                this.switchPart(partHeaders, partId, measureIndex);
                this.parseMusicData(partIndex, partId, partHeaders, partElement);
                this.fireBarLineParsed(0L);
            }
        }
    }

    private Map<String, PartContext> parsePartList(Elements parts) {
        HashMap<String, PartContext> partHeaders = new HashMap<String, PartContext>();
        for (int p = 0; p < parts.size(); ++p) {
            PartContext header = this.parsePartHeader(parts.get(p));
            if (header == null) continue;
            partHeaders.put(header.id, header);
        }
        return partHeaders;
    }

    private PartContext parsePartHeader(Element part) {
        if (part.getLocalName().equals("part-group")) {
            return null;
        }
        PartContext partHeader = new PartContext(part.getAttribute("id").getValue(), part.getFirstChildElement("part-name").getValue());
        Elements midiInsts = part.getChildElements("midi-instrument");
        for (int x = 0; x < midiInsts.size(); ++x) {
            Element midi_instrument = midiInsts.get(x);
            String instrumentId = midi_instrument.getAttribute("id").getValue();
            String channel = this.getStringValueOrNull(midi_instrument.getFirstChildElement("midi-channel"));
            String name = this.getStringValueOrNull(midi_instrument.getFirstChildElement("midi-name"));
            String bank = this.getStringValueOrNull(midi_instrument.getFirstChildElement("midi-bank"));
            byte program = this.getByteValueOrDefault(midi_instrument.getFirstChildElement("midi-program"), (byte)0);
            String unpitched = this.getStringValueOrNull(midi_instrument.getFirstChildElement("midi-unpitched"));
            partHeader.instruments[x] = new MidiInstrument(instrumentId, channel, name, bank, program, unpitched);
        }
        return partHeader;
    }

    private String getStringValueOrNull(Element element) {
        return element == null ? null : element.getValue();
    }

    private void parseMusicData(int partIndex, String partId, Map<String, PartContext> partHeaders, Element musicDataRoot) {
        Element attributes = musicDataRoot.getFirstChildElement("attributes");
        if (attributes != null) {
            KeySignature ks = this.parseKeySignature(attributes);
            if (!this.keySignature.equals(ks)) {
                this.keySignature = ks;
                this.fireKeySignatureParsed(this.keySignature.getKey(), this.keySignature.getScale());
            }
            this.divisionsPerBeat = this.getByteValueOrDefault(attributes.getFirstChildElement("divisions"), this.divisionsPerBeat);
            this.beatsPerMeasure = this.getByteValueOrDefault(this.getRecursiveFirstChildElement(attributes, "time", "beats"), this.beatsPerMeasure);
        }
        Elements childs = musicDataRoot.getChildElements();
        for (int i = 0; i < childs.size(); ++i) {
            Element sound;
            Element el = childs.get(i);
            if (el.getLocalName().equals("harmony")) {
                this.parseGuitarChord(el);
                continue;
            }
            if (el.getLocalName().equals("note")) {
                this.parseNote(partIndex, el, partId, partHeaders);
                continue;
            }
            if (!el.getLocalName().equals("direction") || (sound = el.getFirstChildElement("sound")) == null) continue;
            String value = sound.getAttributeValue("dynamics");
            if (value != null) {
                this.currentPart.currentVolume = Byte.parseByte(value);
            }
            if ((value = sound.getAttributeValue("tempo")) == null) continue;
            for (MidiInstrument mi : this.currentPart.instruments) {
                System.out.println(mi);
            }
            this.fireTempoChanged(Integer.parseInt(value));
        }
    }

    private void switchPart(Map<String, PartContext> partHeaders, String partString, int partId) {
        this.currentPart = partHeaders.get(partString);
        if (this.currentPart.voice >= 0) {
            this.fireTrackChanged(this.currentPart.voice);
        } else if (this.currentPart.instruments[0] == null) {
            this.parseVoice(partId, Integer.parseInt(this.currentPart.id));
            this.parseInstrumentNameAndFireChange(this.currentPart.name);
            this.currentLayer = 0;
            this.fireLayerChanged(this.currentLayer);
        } else {
            if (this.currentPart.instruments[0].channel != null) {
                this.parseVoice(partId, Integer.parseInt(this.currentPart.instruments[0].channel));
            }
            this.parseInstrumentAndFireChange(this.currentPart.instruments[0]);
            this.currentLayer = 0;
            this.fireLayerChanged(this.currentLayer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeySignature parseKeySignature(Element attributes) {
        byte key = this.keySignature.getKey();
        byte scale = this.keySignature.getScale();
        Element attr = attributes.getFirstChildElement("key");
        if (attr == null) return new KeySignature(key, scale);
        key = this.getByteValueOrDefault(attr.getFirstChildElement("fifths"), key);
        Element eMode = attr.getFirstChildElement("mode");
        if (eMode != null) {
            String mode = eMode.getValue();
            if (mode.equalsIgnoreCase("major")) {
                scale = 0;
                return new KeySignature(key, scale);
            } else {
                if (!mode.equalsIgnoreCase("minor")) throw new RuntimeException("Error in key signature: " + mode);
                scale = 1;
            }
            return new KeySignature(key, scale);
        } else {
            scale = 0;
        }
        return new KeySignature(key, scale);
    }

    private Element getRecursiveFirstChildElement(Element element, String ... childs) {
        Element el = element;
        for (String c : childs) {
            if (el == null) {
                return null;
            }
            el = el.getFirstChildElement(c);
        }
        return el;
    }

    private byte getByteValueOrDefault(Element element, byte defaultValue) {
        if (element != null) {
            int value = Integer.parseInt(element.getValue());
            return (byte)value;
        }
        return defaultValue;
    }

    private void parseGuitarChord(Element harmony) {
        Element chord_inv;
        String chord_kind_str;
        StringBuilder chordString = new StringBuilder(" ");
        this.appendToChord(chordString, harmony, "root");
        Element chord_kind = harmony.getFirstChildElement("kind");
        if (chord_kind != null && (chord_kind_str = XMLtoJFchordMap.get(chord_kind.getValue())) != null) {
            chordString.append(chord_kind_str);
        }
        if ((chord_inv = harmony.getFirstChildElement("inversion")) != null) {
            Integer inv_value = Integer.parseInt(chord_inv.getValue());
            Integer i = 0;
            while (i < inv_value) {
                chordString.append("^");
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        this.appendToChord(chordString, harmony, "bass");
        this.fireChordParsed(new Chord(chordString.toString()));
    }

    private void appendToChord(StringBuilder chordString, Element harmony, String base) {
        Element chord_root = harmony.getFirstChildElement(base);
        if (chord_root != null) {
            Element chord_root_alter;
            Element chord_root_step = chord_root.getFirstChildElement(base + "-step");
            if (chord_root_step != null) {
                chordString.append(chord_root_step.getValue());
            }
            if ((chord_root_alter = chord_root.getFirstChildElement(base + "-alter")) != null) {
                if (chord_root_alter.getValue().equals("-1")) {
                    chordString.append("b");
                }
                if (chord_root_alter.getValue().equals("+1")) {
                    chordString.append("#");
                }
            }
        }
    }

    private void parseNote(int p, Element noteElement, String partId, Map<String, PartContext> partHeaders) {
        Element lyric_text_element;
        Element tied;
        Note newNote = new Note();
        newNote.setFirstNote(true);
        boolean isRest = false;
        boolean isStartOfTie = false;
        boolean isEndOfTie = false;
        int noteNumber = 0;
        byte octaveNumber = 0;
        if (noteElement.getFirstChildElement("grace") != null) {
            return;
        }
        Element voice = noteElement.getFirstChildElement("voice");
        if (voice != null && !newNote.isHarmonicNote() && Byte.parseByte(voice.getValue()) - 1 != this.currentLayer) {
            this.currentLayer = Byte.parseByte(voice.getValue());
            this.currentLayer = (byte)(this.currentLayer - 1);
            this.fireLayerChanged(this.currentLayer);
        }
        this.enhanceFromChord(noteElement, newNote);
        Elements noteEls = noteElement.getChildElements();
        for (int i = 0; i < noteEls.size(); ++i) {
            Element element = noteEls.get(i);
            String tagName = element.getQualifiedName();
            if (tagName.equals("instrument")) {
                PartContext header = partHeaders.get(partId);
                MidiInstrument[] instruments = header.instruments;
                for (int y = 0; y < instruments.length; ++y) {
                    MidiInstrument ins = instruments[y];
                    if (ins == null || !ins.id.equals(element.getAttributeValue("id"))) continue;
                    this.parseVoice(p, this.findInstrument(ins));
                    this.parseInstrumentAndFireChange(ins);
                }
                continue;
            }
            if (tagName.equals("unpitched")) {
                Element display_octave;
                newNote.setPercussionNote(true);
                Element display_note = element.getFirstChildElement("display-step");
                if (display_note != null) {
                    noteNumber = this.getNoteNumber(display_note.getValue().charAt(0));
                }
                if ((display_octave = element.getFirstChildElement("display-octave")) == null) continue;
                Byte octave_byte = new Byte(display_octave.getValue());
                noteNumber = (byte)(noteNumber + octave_byte * 12);
                continue;
            }
            if (tagName.equals("pitch")) {
                int intNoteNumber;
                String sStep = element.getFirstChildElement("step").getValue();
                noteNumber = this.getNoteNumber(sStep.charAt(0));
                Element alter = element.getFirstChildElement("alter");
                if (alter != null) {
                    if ((noteNumber = (byte)(noteNumber + Integer.parseInt(alter.getValue()))) > 11) {
                        noteNumber = 0;
                    } else if (noteNumber < 0) {
                        noteNumber = 11;
                    }
                }
                if ((intNoteNumber = (octaveNumber = this.getByteValueOrDefault(element.getFirstChildElement("octave"), octaveNumber)) * 12 + noteNumber) > 127) {
                    throw new RuntimeException("Note value " + intNoteNumber + " is larger than 127");
                }
                noteNumber = (byte)intNoteNumber;
                continue;
            }
            if (!tagName.equals("rest")) continue;
            isRest = true;
        }
        Element element_duration = noteElement.getFirstChildElement("duration");
        double durationValue = Double.parseDouble(element_duration.getValue());
        double decimalDuration = durationValue / (double)(this.divisionsPerBeat * this.beatsPerMeasure);
        Element notations = noteElement.getFirstChildElement("notations");
        if (notations != null && (tied = notations.getFirstChildElement("tied")) != null) {
            String tiedValue = tied.getAttributeValue("type");
            if (tiedValue.equalsIgnoreCase("start")) {
                isStartOfTie = true;
            } else if (tiedValue.equalsIgnoreCase("stop")) {
                isEndOfTie = true;
            }
        }
        byte attackVelocity = this.currentPart.currentVolume;
        byte decayVelocity = this.curVelocity;
        if (isRest) {
            newNote.setRest(true);
            newNote.setDuration(decimalDuration);
            newNote.setOnVelocity((byte)0);
            newNote.setOffVelocity((byte)0);
        } else {
            newNote.setValue((byte)noteNumber);
            newNote.setDuration(decimalDuration);
            newNote.setStartOfTie(isStartOfTie);
            newNote.setEndOfTie(isEndOfTie);
            newNote.setOnVelocity(attackVelocity);
            newNote.setOffVelocity(decayVelocity);
        }
        this.fireNoteParsed(newNote);
        Element lyric = noteElement.getFirstChildElement("lyric");
        if (lyric != null && (lyric_text_element = lyric.getFirstChildElement("text")) != null) {
            this.fireLyricParsed(lyric_text_element.getValue());
        }
    }

    private byte getNoteNumber(char step) {
        byte note = 0;
        switch (step) {
            case 'C': {
                note = 0;
                break;
            }
            case 'D': {
                note = 2;
                break;
            }
            case 'E': {
                note = 4;
                break;
            }
            case 'F': {
                note = 5;
                break;
            }
            case 'G': {
                note = 7;
                break;
            }
            case 'A': {
                note = 9;
                break;
            }
            case 'B': {
                note = 11;
            }
        }
        return note;
    }

    private int findInstrument(MidiInstrument instrument) {
        if (instrument.name != null) {
            return MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(instrument.name).byteValue();
        }
        return 0;
    }

    private void enhanceFromChord(Element noteElement, Note note) {
        Elements note_elements = noteElement.getChildElements();
        for (int i = 0; i < note_elements.size(); ++i) {
            Element element = note_elements.get(i);
            String tagName = element.getQualifiedName();
            if (!tagName.equals("chord")) continue;
            note.setHarmonicNote(true);
            note.setFirstNote(false);
        }
    }

    private void parseVoice(int part, int voice) {
        if (voice == 10) {
            this.fireTrackChanged((byte)voice);
        } else {
            int voiceNumber = -1;
            for (byte x = 0; x < this.nextVoice; x = (byte)(x + 1)) {
                if (part != this.voices[x].part || voice != this.voices[x].voice) continue;
                voiceNumber = x;
                break;
            }
            if (voiceNumber == -1) {
                voiceNumber = this.nextVoice;
                this.voices[voiceNumber] = new VoiceDefinition(part, voice);
                this.nextVoice = (byte)(this.nextVoice + 1);
            }
            if (voiceNumber != this.currentVoice) {
                this.fireTrackChanged((byte)voiceNumber);
            }
            this.currentVoice = voiceNumber;
        }
    }

    private void parseInstrumentNameAndFireChange(String name) {
        int instrumentNumber;
        try {
            instrumentNumber = Byte.parseByte(name);
        }
        catch (NumberFormatException e) {
            Byte value = MidiDictionary.INSTRUMENT_STRING_TO_BYTE.get(name);
            int n = instrumentNumber = value == null ? -1 : (int)value.byteValue();
        }
        if (instrumentNumber <= -1) {
            throw new RuntimeException();
        }
        this.fireInstrumentParsed((byte)instrumentNumber);
    }

    private void parseInstrumentAndFireChange(MidiInstrument instrument) {
        if (instrument.program >= 0) {
            this.fireInstrumentParsed(instrument.program);
        } else if (instrument.name != null) {
            this.parseInstrumentNameAndFireChange(instrument.name);
        } else {
            throw new RuntimeException("Couldn't determine the instrument. Possibly and unhandled case. Please report with the musicXML data.");
        }
    }

    public static int BPMtoPPM(float bpm) {
        return new Float(14400.0f / bpm).intValue();
    }

    static {
        XMLtoJFchordMap.put("major", "MAJ");
        XMLtoJFchordMap.put("major-sixth", "MAJ6");
        XMLtoJFchordMap.put("major-seventh", "MAJ7");
        XMLtoJFchordMap.put("major-ninth", "MAJ9");
        XMLtoJFchordMap.put("major-13th", "MAJ13");
        XMLtoJFchordMap.put("minor", "MIN");
        XMLtoJFchordMap.put("minor-sixth", "MIN6");
        XMLtoJFchordMap.put("minor-seventh", "MIN7");
        XMLtoJFchordMap.put("minor-ninth", "MIN9");
        XMLtoJFchordMap.put("minor-11th", "MIN11");
        XMLtoJFchordMap.put("major-minor", "MINMAJ7");
        XMLtoJFchordMap.put("dominant", "DOM7");
        XMLtoJFchordMap.put("dominant-11th", "DOM7%11");
        XMLtoJFchordMap.put("dominant-ninth", "DOM9");
        XMLtoJFchordMap.put("dominant-13th", "DOM13");
        XMLtoJFchordMap.put("augmented", "AUG");
        XMLtoJFchordMap.put("augmented-seventh", "AUG7");
        XMLtoJFchordMap.put("diminished", "DIM");
        XMLtoJFchordMap.put("diminished-seventh", "DIM7");
        XMLtoJFchordMap.put("suspended-fourth", "SUS4");
        XMLtoJFchordMap.put("suspended-second", "SUS2");
    }

    private static class KeySignature {
        private final byte key;
        private final byte scale;

        public KeySignature(byte key, byte scale) {
            this.key = key;
            this.scale = scale;
        }

        public byte getKey() {
            return this.key;
        }

        public byte getScale() {
            return this.scale;
        }

        public boolean equals(Object o) {
            if (o instanceof KeySignature) {
                KeySignature other = (KeySignature)o;
                return other.key == this.key && other.scale == this.scale;
            }
            return false;
        }
    }

    private static class VoiceDefinition {
        int part;
        int voice;

        public VoiceDefinition(int part, int voice) {
            this.part = part;
            this.voice = voice;
        }
    }

    private static class PartContext {
        public String id;
        public String name;
        public MidiInstrument[] instruments;
        private byte currentVolume = (byte)90;
        public byte voice;

        public PartContext(String id, String name) {
            this.id = id;
            this.name = name;
            this.instruments = new MidiInstrument[16];
        }
    }

    private static class MidiInstrument {
        private String id;
        private String channel;
        private String name;
        private String bank;
        private byte program;
        private String unpitched;

        public MidiInstrument(String id, String channel, String name, String bank, byte program, String unpitched) {
            this.id = id;
            this.channel = channel;
            this.name = name;
            this.bank = bank;
            this.program = program;
            this.unpitched = unpitched;
        }
    }
}

