# Migration `20201202043608-create-review`

This migration has been generated by Juliana Amoasei at 12/2/2020, 1:36:08 AM.
You can check out the [state of the schema](./schema.prisma) after the migration.

## Database Steps

```sql
ALTER TABLE `posts` MODIFY `publicado` BOOLEAN NOT NULL DEFAULT false,
    MODIFY `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3)

ALTER TABLE `users` MODIFY `createdAt` DATETIME(3) NOT NULL DEFAULT CURRENT_TIMESTAMP(3)

CREATE TABLE `reviews` (
    `id` INT NOT NULL AUTO_INCREMENT,
    `postId` INT NOT NULL,
    `reviewerId` INT NOT NULL,
    `nota` INT NOT NULL,

    PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci

ALTER TABLE `reviews` ADD FOREIGN KEY (`postId`) REFERENCES `posts`(`id`) ON DELETE CASCADE ON UPDATE CASCADE

ALTER TABLE `reviews` ADD FOREIGN KEY (`reviewerId`) REFERENCES `users`(`id`) ON DELETE CASCADE ON UPDATE CASCADE
```

## Changes

```diff
diff --git schema.prisma schema.prisma
migration ..20201202043608-create-review
--- datamodel.dml
+++ datamodel.dml
@@ -1,0 +1,42 @@
+generator client {
+  provider = "prisma-client-js"
+}
+
+datasource db {
+  provider = "mysql"
+  url = "***"
+}
+
+model Post {
+  id        Int       @id @default(autoincrement())
+  titulo    String
+  conteudo  String
+  autorId   Int
+  publicado Boolean   @default(false)
+  createdAt DateTime  @default(now())
+  autor     User     @relation(fields: [autorId], references: [id])
+
+  @@index([autorId], name: "autorId")
+  @@map(name: "posts")
+}
+
+model User {
+  id        Int       @id @default(autoincrement())
+  nome      String
+  email     String
+  createdAt DateTime  @default(now())
+  posts     Post[]
+
+  @@map(name: "users")
+}
+
+model Review {
+  id          Int     @id @default(autoincrement())
+  postId      Int
+  post        Post    @relation(fields: [postId], references: [id])
+  reviewerId  Int
+  reviewer    User    @relation(fields: [reviewerId], references: [id])
+  nota        Int
+
+  @@map(name: "reviews")
+}
```


