/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.jpa.extra;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.converter.Converter;
import br.com.caelum.vraptor.core.Converters;
import br.com.caelum.vraptor.events.ControllerMethodDiscovered;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.jpa.extra.Load;
import br.com.caelum.vraptor.view.FlashScope;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.util.Arrays;
import javax.enterprise.event.Observes;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import javax.servlet.http.HttpServletRequest;

public class ParameterLoader {
    private final EntityManager em;
    private final HttpServletRequest request;
    private final ParameterNameProvider provider;
    private final Result result;
    private final Converters converters;
    private final FlashScope flash;

    public ParameterLoader(EntityManager em, HttpServletRequest request, ParameterNameProvider provider, Result result, Converters converters, FlashScope flash) {
        this.em = em;
        this.request = request;
        this.provider = provider;
        this.result = result;
        this.converters = converters;
        this.flash = flash;
    }

    public boolean containsLoadAnnotation(ControllerMethod method) {
        return Iterables.any(Arrays.asList(method.getMethod().getParameterAnnotations()), ParameterLoader.hasAnnotation(Load.class));
    }

    public void load(@Observes ControllerMethodDiscovered event) {
        ControllerMethod method = event.getControllerMethod();
        if (!this.containsLoadAnnotation(method)) {
            return;
        }
        Annotation[][] annotations = method.getMethod().getParameterAnnotations();
        Parameter[] parameters = this.provider.parametersFor((AccessibleObject)method.getMethod());
        Class<?>[] types = method.getMethod().getParameterTypes();
        Object[] args = this.flash.consumeParameters(method);
        for (int i = 0; i < parameters.length; ++i) {
            if (!this.hasLoadAnnotation(annotations[i])) continue;
            Object loaded = this.load(parameters[i].getName(), types[i]);
            if (loaded == null) {
                this.result.notFound();
                return;
            }
            if (args != null) {
                args[i] = loaded;
                continue;
            }
            this.request.setAttribute(parameters[i].getName(), loaded);
        }
        this.flash.includeParameters(method, args);
    }

    private <T> Object load(String name, Class type) {
        EntityType entity = this.em.getMetamodel().entity(type);
        Type idType = entity.getIdType();
        Preconditions.checkArgument((idType != null ? 1 : 0) != 0, (String)"Entity %s must have an id property for @Load.", (Object[])new Object[]{type.getSimpleName()});
        SingularAttribute idProperty = entity.getDeclaredId(idType.getJavaType());
        String parameter = this.request.getParameter(name + "." + idProperty.getName());
        if (parameter == null) {
            return null;
        }
        Converter converter = this.converters.to(idType.getJavaType());
        Preconditions.checkArgument((converter != null ? 1 : 0) != 0, (String)"Entity %s id type %s must have a converter", (Object[])new Object[]{type.getSimpleName(), idType});
        Serializable id = (Serializable)converter.convert(parameter, type);
        return this.em.find(type, (Object)id);
    }

    private boolean hasLoadAnnotation(Annotation[] annotation) {
        return !Iterables.isEmpty((Iterable)Iterables.filter(Arrays.asList(annotation), Load.class));
    }

    public static Predicate<Annotation[]> hasAnnotation(final Class<?> annotation) {
        return new Predicate<Annotation[]>(){

            public boolean apply(Annotation[] param) {
                return Iterables.any(Arrays.asList(param), (Predicate)Predicates.instanceOf((Class)annotation));
            }
        };
    }
}

