/*
 * Decompiled with CFR 0.152.
 */
package helper;

import controlador.Diagrama;
import controlador.apoios.TreeItem;
import helper.AjudaManager;
import java.util.ArrayList;
import partepronta.GerenciadorSubParte;
import util.ItemIntStringToList;

public class ParteAjuda
extends GerenciadorSubParte {
    private static final long serialVersionUID = 23051723180000L;
    private final ArrayList<Integer> links = new ArrayList();
    private int ID = 0;
    private ArrayList<ParteAjuda> subs = new ArrayList();
    private ParteAjuda superior = null;
    private String html = "";
    protected AjudaManager master = null;

    public ParteAjuda(String texto, byte[] byteImage, String XMLCopiado, String versaoDiagrama, Diagrama.TipoDeDiagrama tipo) {
        super(texto, byteImage, XMLCopiado, versaoDiagrama, tipo);
    }

    public ParteAjuda(int id, String titulo) {
        this.ID = id;
        this.setTitulo(titulo);
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public AjudaManager getMaster() {
        return this.master;
    }

    public ArrayList<ParteAjuda> getSubs() {
        return this.subs;
    }

    public void setSubs(ArrayList<ParteAjuda> subs) {
        this.subs = subs;
    }

    public ParteAjuda getSuperior() {
        return this.superior;
    }

    protected void setSuperior(ParteAjuda superior) {
        if (this.superior != superior) {
            this.superior = superior;
            this.doMuda();
        }
    }

    public void SetSuperior(ParteAjuda superior) {
        if (this.superior != superior) {
            if (this.isSub(superior)) {
                return;
            }
            if (this.superior != null) {
                this.superior.getSubs().remove(this);
            }
            this.superior = superior;
            if (this.superior != null) {
                this.superior.getSubs().add(this);
            }
            this.doMuda();
        }
    }

    @Override
    public void setTitulo(String titulo) {
        if (!this.getTitulo().equals(titulo)) {
            super.setTitulo(titulo);
            this.doMuda();
        }
    }

    public ArrayList<Integer> getLinks() {
        return this.links;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int id) {
        if (this.ID != id) {
            this.ID = id;
            this.doMuda();
        }
    }

    public int FindMaxID() {
        return this.FindMaxID(this.getID());
    }

    private int FindMaxID(int p) {
        for (ParteAjuda ia : this.getSubs()) {
            p = Math.max(p, ia.FindMaxID());
        }
        return p;
    }

    public ParteAjuda Add(int id, String titulo) {
        ParteAjuda nw = new ParteAjuda(id, titulo);
        nw.setSuperior(this);
        this.getSubs().add(nw);
        this.master = this.getMaster();
        this.doMuda();
        return nw;
    }

    public void InitParteAjuda(byte[] byteImage, String XMLCopiado, String versaoDiagrama, Diagrama.TipoDeDiagrama tipo) {
        this.InitGerenciadorSubParte(this.getTitulo(), byteImage, XMLCopiado, versaoDiagrama, tipo);
        this.doMuda();
    }

    public ParteAjuda findByID(int id) {
        if (id == this.getID()) {
            return this;
        }
        for (ParteAjuda ia : this.getSubs()) {
            ParteAjuda res = ia.findByID(id);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void PopuleTree(TreeItem tree) {
        TreeItem sub = new TreeItem(this.getTitulo(), this.getID(), "");
        tree.add(sub);
        this.getSubs().stream().forEach(it -> it.PopuleTree(sub));
    }

    public void doMuda() {
        if (this.master != null && this.master != this) {
            this.master.doMuda();
        }
    }

    public void ProcurarPorTexto(String tex, ArrayList<ParteAjuda> encontrados) {
        String tmp = tex.toUpperCase();
        if (this.getTitulo().toUpperCase().contains(tmp)) {
            encontrados.add(this);
        } else if (this.getHtml().toUpperCase().contains(tmp)) {
            encontrados.add(this);
        } else if (this.getXMLCopiado().toUpperCase().contains(tmp)) {
            encontrados.add(this);
        }
        this.getSubs().stream().forEach(s -> s.ProcurarPorTexto(tex, encontrados));
    }

    public void PopuleTopicos(ArrayList<ItemIntStringToList> topicos) {
        topicos.add(new ItemIntStringToList(this.ID, this.getTitulo(), this));
        this.getSubs().stream().forEach(it -> it.PopuleTopicos(topicos));
    }

    private boolean isSub(ParteAjuda proc) {
        return this.subs.stream().filter(s -> s == proc || s.isSub(proc)).findAny().isPresent();
    }
}

