/*
 * Decompiled with CFR 0.152.
 */
package desenho.formas;

import controlador.Diagrama;
import controlador.Editor;
import controlador.apoios.TreeItem;
import controlador.inspector.InspectorProperty;
import desenho.FormaElementar;
import desenho.formas.Forma;
import desenho.linhas.PontoDeLinha;
import desenho.preDiagrama.baseDrawerItem;
import desenho.preDiagrama.iBaseDrawer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import util.BrLogger;
import util.Dialogos;
import util.TratadorDeImagens;
import util.Utilidades;
import util.XMLGenerate;

public class Desenhador
extends Forma
implements iBaseDrawer {
    private static final long serialVersionUID = -6675432580840672702L;
    public final int TIPOSETA = 0;
    public final int TIPOIMG = 1;
    public final int TIPODEZ = 2;
    private int tipo = 1;
    private transient BufferedImage imgSeta = null;
    private transient BufferedImage imagem = null;
    private float alfa = 1.0f;
    private String imgName = "";
    private int anguloSeta = 0;
    private boolean setaPontaDireita = true;
    private boolean setaPontaEsquerda = true;
    private int setaLargura = 2;
    private int desvioX = 0;
    private int desvioY = 0;
    private Color setaCor = Color.BLACK;
    private boolean simplesDezenho = true;
    transient Image imgres = null;
    private byte[] byteImage = null;
    private ArrayList<baseDrawerItem> Itens = new ArrayList();

    public Desenhador(Diagrama diagrama) {
        super(diagrama);
    }

    public void setImgName(String imgName) {
        this.imgName = imgName;
    }

    public int getTipo() {
        return this.tipo;
    }

    public void setTipo(int tipo) {
        if (this.tipo != tipo) {
            if (!this.getMaster().isCarregando && !Dialogos.ShowMessageConfirmYES(this.getMaster().getEditor().getRootPane(), Editor.fromConfiguracao.getValor("Inspector.obj.desenhador.msg_muada_tipo"))) {
                return;
            }
            this.tipo = tipo;
            this.ReajusteDesenho();
        }
    }

    public boolean isTipoSeta() {
        return this.tipo == 0;
    }

    public boolean isTipoDesenho() {
        return this.tipo == 2;
    }

    public boolean isTipoImg() {
        return this.tipo == 1;
    }

    public void setTipoSeta() {
        this.setTipo(0);
    }

    public void setTipoImg() {
        this.setTipo(1);
    }

    public float getAlfa() {
        return this.alfa;
    }

    public void setAlfa(float alfa) {
        this.alfa = alfa;
        this.InvalidateArea();
    }

    public void SetAlfa(int alfa) {
        this.alfa = (float)alfa / 100.0f;
        if (this.alfa > 1.0f) {
            this.alfa = 0.5f;
        }
        this.InvalidateArea();
    }

    @Override
    public void DoPaint(Graphics2D g) {
        if (this.isTipoSeta()) {
            this.DrawSeta(g);
        } else if (this.isTipoImg()) {
            this.DrawImagem(g);
        } else {
            Rectangle bkpA = g.getClipBounds();
            Rectangle r = this.getBounds();
            g.clipRect(r.x, r.y, r.width, r.height);
            Color bkp = g.getColor();
            for (baseDrawerItem bi : this.getItens()) {
                bi.setDisablePainted(this.isDisablePainted());
                bi.DoPaint(g);
            }
            g.setColor(bkp);
            g.setClip(bkpA);
        }
        if (this.imgres == null && this.imgSeta == null && !this.isTipoDesenho()) {
            Color bkp = g.getColor();
            g.setColor(this.isDisablePainted() ? this.disabledColor : Color.LIGHT_GRAY);
            g.drawRect(this.getLeft(), this.getTop(), this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(bkp);
        }
        super.DoPaint(g);
    }

    public int getSetaLargura() {
        return this.setaLargura;
    }

    public void setSetaLargura(int setaLargura) {
        if (this.setaLargura != setaLargura) {
            this.setaLargura = setaLargura;
            this.ReajusteDesenho();
        }
    }

    public Color getSetaCor() {
        return this.isDisablePainted() ? this.disabledColor : this.setaCor;
    }

    public void setSetaCor(Color setaCor) {
        if (this.setaCor != setaCor) {
            this.setaCor = setaCor;
            this.ReajusteDesenho();
        }
    }

    public int getAnguloSeta() {
        return this.anguloSeta;
    }

    public void setAnguloSeta(int anguloSeta) {
        if (this.anguloSeta != anguloSeta) {
            this.anguloSeta = anguloSeta;
            this.ReajusteDesenho();
        }
    }

    public int getDesvioX() {
        return this.desvioX;
    }

    public void setDesvioX(int desvioX) {
        if (this.desvioX != desvioX) {
            this.desvioX = desvioX;
            this.ReajusteDesenho();
        }
    }

    public int getDesvioY() {
        return this.desvioY;
    }

    public void setDesvioY(int desvioy) {
        if (this.desvioY != desvioy) {
            this.desvioY = desvioy;
            this.ReajusteDesenho();
        }
    }

    public boolean isSetaPontaDireita() {
        return this.setaPontaDireita;
    }

    public void setSetaPontaDireita(boolean setaPontaDireita) {
        if (this.setaPontaDireita != setaPontaDireita) {
            this.setaPontaDireita = setaPontaDireita;
            this.ReajusteDesenho();
        }
    }

    public boolean isSetaPontaEsquerda() {
        return this.setaPontaEsquerda;
    }

    public void setSetaPontaEsquerda(boolean setaPontaEsquerda) {
        if (this.setaPontaEsquerda != setaPontaEsquerda) {
            this.setaPontaEsquerda = setaPontaEsquerda;
            this.ReajusteDesenho();
        }
    }

    private void DrawSeta(Graphics2D g) {
        if (this.imgSeta == null) {
            int tmp;
            int x2;
            int y2;
            int y;
            int x;
            int rec;
            Rectangle recSeta = null;
            Rectangle pos = new Rectangle(0, 0, this.getWidth() - 4, this.getHeight() - 4);
            int angulo = this.getAnguloSeta();
            if (angulo < 0) {
                angulo *= -1;
            }
            while (angulo > 180) {
                angulo -= 180;
            }
            double catOp = (double)pos.height / 2.0;
            double senORcos = Math.sin(Math.toRadians(angulo));
            double hip = catOp / senORcos;
            double catAd = Math.sqrt(hip * hip - catOp * catOp);
            if (catAd <= (double)(pos.width / 2)) {
                rec = (int)(((double)pos.width - 2.0 * catAd) / 2.0);
                x = rec + pos.x;
                y = 0 + pos.y;
                y2 = 0 + pos.height + pos.y;
                x2 = -rec + pos.x + pos.width;
                if (angulo > 90) {
                    tmp = x;
                    x = x2;
                    x2 = tmp;
                }
            } else {
                catAd = pos.width / 2;
                senORcos = Math.cos(Math.toRadians(angulo));
                hip = catAd / senORcos;
                catOp = Math.sqrt(hip * hip - catAd * catAd);
                rec = (int)(((double)pos.height - 2.0 * catOp) / 2.0);
                x = pos.x;
                y = rec + pos.y;
                y2 = pos.height + pos.y - rec;
                x2 = pos.x + pos.width;
                if (angulo > 90) {
                    tmp = y;
                    y = y2;
                    y2 = tmp;
                }
            }
            recSeta = new Rectangle(x + this.desvioX, y + this.desvioY, x2 - this.desvioX, y2 - this.desvioY);
            BufferedImage bi = new BufferedImage(pos.width, pos.height, 2);
            Graphics gg = bi.getGraphics();
            gg.setColor(this.getSetaCor());
            this.drawArrow((Graphics2D)gg, recSeta.x, recSeta.y, recSeta.width, recSeta.height);
            this.imgSeta = bi;
        }
        g.drawImage((Image)this.imgSeta, this.getLeft() + 2, this.getTop() + 2, null);
    }

    private void drawArrow(Graphics2D g, int x1, int y1, int x2, int y2) {
        RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.addRenderingHints(renderHints);
        g.setStroke(new BasicStroke(this.getSetaLargura(), 1, 1));
        int ARR_SIZE = 3 + this.getSetaLargura();
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g.setTransform(at);
        g.drawLine(ARR_SIZE, 0, len - ARR_SIZE, 0);
        if (this.isSetaPontaEsquerda()) {
            g.fillPolygon(new int[]{len, len - ARR_SIZE, len - ARR_SIZE, len}, new int[]{0, -ARR_SIZE, ARR_SIZE, 0}, 4);
        }
        if (this.isSetaPontaDireita()) {
            g.fillPolygon(new int[]{0, ARR_SIZE, ARR_SIZE, 0}, new int[]{0, -ARR_SIZE, ARR_SIZE, 0}, 4);
        }
    }

    @Override
    public void ReSized() {
        super.ReSized();
        if (this.isTipoSeta() && this.imgSeta != null && (this.imgSeta.getWidth() + 4 != this.getWidth() || this.imgSeta.getHeight() + 4 != this.getHeight())) {
            this.imgSeta = null;
        }
        if (this.isTipoImg() && this.imgres != null && (this.imgres.getWidth(null) + 4 != this.getWidth() || this.imgres.getHeight(null) + 4 != this.getHeight())) {
            this.imgres = null;
        }
    }

    @Override
    public ArrayList<InspectorProperty> GenerateProperty() {
        ArrayList<InspectorProperty> res = super.GenerateProperty();
        res.add(InspectorProperty.PropertyFactorySeparador("desenhador"));
        ArrayList<String> men = new ArrayList<String>();
        men.add(Editor.fromConfiguracao.getValor("Inspector.lst.desenhador.seta"));
        men.add(Editor.fromConfiguracao.getValor("Inspector.lst.desenhador.imagem"));
        men.add(Editor.fromConfiguracao.getValor("Inspector.lst.desenhador.desenholivre"));
        InspectorProperty txtTipo = InspectorProperty.PropertyFactoryMenu("desenhador.tipo", "setTipo", this.getTipo(), men);
        res.add(txtTipo);
        txtTipo.AddCondicao(new String[]{"0"}, new String[]{"setAnguloSeta", "setSetaCor", "setSetaLargura", "setDesvioX", "setDesvioY", "setSetaPontaDireita", "setSetaPontaEsquerda"});
        txtTipo.AddCondicao(new String[]{"1"}, new String[]{FormaElementar.nomeComandos.cmdLoadImg.name(), "SetAlfa", "desenhador.imagem.arquivo", "desenhador.imagem.size", FormaElementar.nomeComandos.cmdDoAnyThing.name()});
        txtTipo.AddCondicao(new String[]{"2"}, new String[]{FormaElementar.nomeComandos.cmdCallDrawerEditor.name()});
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdLoadImg.name()));
        res.add(InspectorProperty.PropertyFactoryNumero("diagrama.detalhe.alfa", "SetAlfa", (int)(100.0f * this.getAlfa())));
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("desenhador.imagem.arquivo", this.getImgName()));
        Point p = this.GetImgSize();
        res.add(InspectorProperty.PropertyFactoryApenasLeituraTexto("desenhador.imagem.size", "(" + String.valueOf(p.x) + " ," + String.valueOf(p.y) + ")"));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdDoAnyThing.name(), "desenhador.imagem.resize").setTag(1));
        res.add(InspectorProperty.PropertyFactoryNumero("seta.angulo", "setAnguloSeta", this.getAnguloSeta()));
        res.add(InspectorProperty.PropertyFactoryCor("seta.cor", "setSetaCor", this.getSetaCor()));
        res.add(InspectorProperty.PropertyFactoryNumero("seta.largura", "setSetaLargura", this.getSetaLargura()));
        res.add(InspectorProperty.PropertyFactoryNumero("seta.desvio.x", "setDesvioX", this.getDesvioX()));
        res.add(InspectorProperty.PropertyFactoryNumero("seta.desvio.y", "setDesvioY", this.getDesvioY()));
        res.add(InspectorProperty.PropertyFactorySN("seta.pontadireita", "setSetaPontaDireita", this.isSetaPontaDireita()));
        res.add(InspectorProperty.PropertyFactorySN("seta.pontaesquerda", "setSetaPontaEsquerda", this.isSetaPontaEsquerda()));
        res.add(InspectorProperty.PropertyFactoryCommand(FormaElementar.nomeComandos.cmdCallDrawerEditor.name()));
        InspectorProperty tmp = InspectorProperty.FindByProperty(res, "setTexto");
        tmp.ReSetCaptionFromConfig("texto");
        tmp = InspectorProperty.FindByProperty(res, "setTextoAdicional");
        res.remove(tmp);
        return res;
    }

    public boolean isSimplesDezenho() {
        return this.simplesDezenho;
    }

    public void setSimplesDezenho(boolean simplesDezenho) {
        this.simplesDezenho = simplesDezenho;
    }

    @Override
    protected void DoPaintDoks(Graphics2D g) {
        if (!this.simplesDezenho) {
            super.DoPaintDoks(g);
        }
    }

    @Override
    public boolean CanLiga(PontoDeLinha aThis) {
        if (!this.simplesDezenho) {
            return super.CanLiga(aThis);
        }
        return false;
    }

    private void ReajusteDesenho() {
        this.imgSeta = null;
        this.imgres = null;
        this.imagem = null;
        this.byteImage = null;
        this.imgName = "";
        this.getItens().clear();
        this.InvalidateArea();
    }

    @Override
    public void DoAnyThing(int Tag) {
        super.DoAnyThing(Tag);
        this.Proporcao();
        this.InvalidateArea();
    }

    public void DrawImagem(Graphics2D g) {
        BufferedImage imgB = this.getImagem();
        if (imgB == null) {
            return;
        }
        Rectangle rec = this.getBounds();
        rec.grow(-2, -2);
        if (this.imgres == null) {
            this.imgres = imgB.getScaledInstance(rec.width, rec.height, 4);
        }
        Composite originalComposite = g.getComposite();
        if (this.alfa != 1.0f) {
            int type = 3;
            g.setComposite(AlphaComposite.getInstance(type, this.alfa));
        }
        Image img = this.imgres;
        if (this.isDisablePainted()) {
            img = TratadorDeImagens.dye(new ImageIcon(this.imgres), this.disabledColor);
        }
        g.drawImage(img, rec.x, rec.y, null);
        g.setComposite(originalComposite);
    }

    public BufferedImage getImagem() {
        if (this.imagem == null && this.byteImage != null) {
            this.imagem = this.fromByteArray(this.byteImage);
        }
        return this.imagem;
    }

    public void setImagem(BufferedImage imagem) {
        this.byteImage = this.toByteArray(imagem);
        this.imagem = imagem;
    }

    private BufferedImage fromByteArray(byte[] imagebytes) {
        return TratadorDeImagens.fromByteArray(imagebytes);
    }

    private byte[] toByteArray(BufferedImage bufferedImage) {
        return TratadorDeImagens.toByteArray(bufferedImage);
    }

    public boolean LoadImageFromFile(String arq) {
        this.imagem = null;
        this.imgres = null;
        this.byteImage = null;
        this.imgName = "";
        this.setTipoImg();
        try {
            File fimg = new File(arq);
            this.setImgName(fimg.getName());
            this.setImagem(ImageIO.read(fimg));
            this.Proporcao();
            this.InvalidateArea();
        }
        catch (IOException iOException) {
            this.InvalidateArea();
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", iOException.getMessage());
            return false;
        }
        catch (Exception e) {
            this.InvalidateArea();
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", e.getMessage());
            return false;
        }
        if (this.imagem == null) {
            BrLogger.Logger("ERROR_OPEN_FILE_IMG", "[EMPTY IMG?]", "[]");
            return false;
        }
        return true;
    }

    public Point GetImgSize() {
        BufferedImage img = this.getImagem();
        Point res = new Point();
        if (img != null) {
            res = new Point(img.getWidth(), img.getHeight());
        }
        return res;
    }

    private void Proporcao() {
        if (this.GetImgSize().x == 0 || this.GetImgSize().y == 0) {
            return;
        }
        int x = this.GetImgSize().y * this.getWidth() / this.GetImgSize().x;
        this.setHeight(x);
        this.Reposicione();
    }

    @Override
    protected void ToXmlValores(Document doc, Element me) {
        super.ToXmlValores(doc, me);
        me.appendChild(XMLGenerate.ValorInteger(doc, "Tipo", this.getTipo()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "SetaLargura", this.getSetaLargura()));
        me.appendChild(XMLGenerate.ValorColor(doc, "SetaCor", this.getSetaCor()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "AnguloSeta", this.getAnguloSeta()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "DesvioX", this.getDesvioX()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "DesvioY", this.getDesvioY()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "SetaPontaDireita", this.isSetaPontaDireita()));
        me.appendChild(XMLGenerate.ValorBoolean(doc, "SetaPontaEsquerda", this.isSetaPontaEsquerda()));
        me.appendChild(XMLGenerate.ValorInteger(doc, "ImagemAlpha", (int)(this.alfa * 100.0f)));
        me.appendChild(XMLGenerate.ValorString(doc, "ImagemNome", this.imgName));
        Element e = XMLGenerate.ValorInteger(doc, "DrawerItens", this.getItens().size());
        this.getItens().stream().forEach(bi -> bi.ToXml(doc, e));
        me.appendChild(e);
        if (this.byteImage != null) {
            me.appendChild(XMLGenerate.ValorText(doc, "Image", Utilidades.Hexadecimal(this.byteImage)));
        }
    }

    @Override
    public boolean LoadFromXML(Element me, boolean colando) {
        Element inter;
        if (!super.LoadFromXML(me, colando)) {
            return false;
        }
        this.setTipo(XMLGenerate.getValorIntegerFrom(me, "Tipo"));
        this.setSetaLargura(XMLGenerate.getValorIntegerFrom(me, "SetaLargura"));
        Color c = XMLGenerate.getValorColorFrom(me, "SetaCor");
        if (c != null) {
            this.setSetaCor(c);
        }
        this.setAnguloSeta(XMLGenerate.getValorIntegerFrom(me, "AnguloSeta"));
        this.setDesvioX(XMLGenerate.getValorIntegerFrom(me, "DesvioX"));
        this.setDesvioY(XMLGenerate.getValorIntegerFrom(me, "DesvioY"));
        this.setSetaPontaDireita(XMLGenerate.getValorBooleanFrom(me, "SetaPontaDireita"));
        this.setSetaPontaEsquerda(XMLGenerate.getValorBooleanFrom(me, "SetaPontaEsquerda"));
        this.SetAlfa(XMLGenerate.getValorIntegerFrom(me, "ImagemAlpha"));
        this.setImgName(XMLGenerate.getValorStringFrom(me, "ImagemNome"));
        String tmp = XMLGenerate.getValorTextoFrom(me, "Image");
        if (tmp != null) {
            this.byteImage = Utilidades.HexadecimalToByteArr(tmp);
        }
        if ((inter = XMLGenerate.FindByNodeName(me, "DrawerItens")) != null) {
            for (int s = 0; s < inter.getChildNodes().getLength(); ++s) {
                Node fstNode = inter.getChildNodes().item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                baseDrawerItem item = this.AddItem();
                if (item.LoadFromXML(fstElmnt, colando)) continue;
                return false;
            }
        }
        return true;
    }

    public String getImgName() {
        return this.imgName;
    }

    @Override
    public baseDrawerItem AddItem() {
        baseDrawerItem bi = new baseDrawerItem(this, baseDrawerItem.tipoDrawer.tpRetangulo);
        this.getItens().add(bi);
        return bi;
    }

    @Override
    public ArrayList<baseDrawerItem> getItens() {
        return this.Itens;
    }

    public void setItens(ArrayList<baseDrawerItem> Itens) {
        this.Itens = Itens;
    }

    @Override
    public String FormateUnidadeMedida(int valor) {
        return Integer.toString(valor);
    }

    @Override
    public int getH() {
        return this.getHeight();
    }

    @Override
    public int getL() {
        return this.getLeft();
    }

    @Override
    public int getT() {
        return this.getTop();
    }

    @Override
    public int getW() {
        return this.getWidth();
    }

    @Override
    public boolean MostreSeParaExibicao(TreeItem root) {
        root.add(new TreeItem(Editor.fromConfiguracao.getValor("diagrama.Desenhador.nome"), this.getID(), this.getClass().getSimpleName()));
        return true;
    }

    @Override
    public void PoluleColors(ArrayList<Color> cores) {
        super.PoluleColors(cores);
        if (cores.indexOf(this.getSetaCor()) == -1) {
            cores.add(this.setaCor);
        }
    }
}

