local vstruct = require "vstruct"
local test = require "vstruct.test.common"
local inf = math.huge

-- work around a bug in the Lua constant table optimizer
local z = 0
local nz = -z

local function T(n, buf)
    return test.autotest(tostring(n), "< f8", buf, n)
end

test.group("little-endian ieee doubles")

T(0, "\000\000\000\000\000\000\000\000")
T(4.9406564584124654418e-324, "\001\000\000\000\000\000\000\000")
T(7.4169128616906696301e-309, "\085\085\085\085\085\085\005\000")
T(1.483382572338133926e-308, "\170\170\170\170\170\170\010\000")
T(2.225073858507200889e-308, "\255\255\255\255\255\255\015\000")
T(2.2250738585072013831e-308, "\000\000\000\000\000\000\016\000")
T(2.2250738585072018772e-308, "\001\000\000\000\000\000\016\000")
T(2.9667651446762683461e-308, "\085\085\085\085\085\085\021\000")
T(3.7084564308453353091e-308, "\170\170\170\170\170\170\026\000")
T(4.4501477170144022721e-308, "\255\255\255\255\255\255\031\000")
T(8.9884656743115795386e+307, "\000\000\000\000\000\000\224\127")
T(8.9884656743115815345e+307, "\001\000\000\000\000\000\224\127")
T(1.1984620899082105386e+308, "\085\085\085\085\085\085\229\127")
T(1.4980776123852631234e+308, "\170\170\170\170\170\170\234\127")
T(1.7976931348623157081e+308, "\255\255\255\255\255\255\239\127")
T(4.9406564584124654418e-324, "\001\000\000\000\000\000\000\000")
T(2.225073858507200889e-308, "\255\255\255\255\255\255\015\000")
T(2.2250738585072013831e-308, "\000\000\000\000\000\000\016\000")
T(1.7976931348623157081e+308, "\255\255\255\255\255\255\239\127")
T(inf, "\000\000\000\000\000\000\240\127")
T(0, "\000\000\000\000\000\000\000\000")
T(nz, "\000\000\000\000\000\000\000\128")
T(-4.9406564584124654418e-324, "\001\000\000\000\000\000\000\128")
T(-7.4169128616906696301e-309, "\085\085\085\085\085\085\005\128")
T(-1.483382572338133926e-308, "\170\170\170\170\170\170\010\128")
T(-2.225073858507200889e-308, "\255\255\255\255\255\255\015\128")
T(-2.2250738585072013831e-308, "\000\000\000\000\000\000\016\128")
T(-2.2250738585072018772e-308, "\001\000\000\000\000\000\016\128")
T(-2.9667651446762683461e-308, "\085\085\085\085\085\085\021\128")
T(-3.7084564308453353091e-308, "\170\170\170\170\170\170\026\128")
T(-4.4501477170144022721e-308, "\255\255\255\255\255\255\031\128")
T(-8.9884656743115795386e+307, "\000\000\000\000\000\000\224\255")
T(-8.9884656743115815345e+307, "\001\000\000\000\000\000\224\255")
T(-1.1984620899082105386e+308, "\085\085\085\085\085\085\229\255")
T(-1.4980776123852631234e+308, "\170\170\170\170\170\170\234\255")
T(-1.7976931348623157081e+308, "\255\255\255\255\255\255\239\255")
T(-4.9406564584124654418e-324, "\001\000\000\000\000\000\000\128")
T(-2.225073858507200889e-308, "\255\255\255\255\255\255\015\128")
T(-2.2250738585072013831e-308, "\000\000\000\000\000\000\016\128")
T(-1.7976931348623157081e+308, "\255\255\255\255\255\255\239\255")
T(-inf, "\000\000\000\000\000\000\240\255")
T(nz, "\000\000\000\000\000\000\000\128")
