<?php

namespace Alura\Doctrine\Mapping;

use Alura\Doctrine\Entity\Aluno;
use Alura\Doctrine\Entity\Telefone;
use LaravelDoctrine\Fluent\EntityMapping;
use LaravelDoctrine\Fluent\Fluent;

class TelefoneMapping extends EntityMapping
{
    public function mapFor(): string
    {
        return Telefone::class;
    }

    public function map(Fluent $builder)
    {
        $builder->increments('id');
        $builder->string('numero');
        $builder
            ->manyToOne(Aluno::class, 'aluno')
            ->inversedBy('telefones');
    }
}
