<?php

namespace Alura\Doctrine\Helper;

use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Tools\Setup;
use LaravelDoctrine\Fluent\FluentDriver;

class EntityManagerFactory
{
    public function getEntityManager(): EntityManagerInterface
    {
        $rootDir = __DIR__ . '/../..';
        $connection = [
            'driver' => 'pdo_sqlite',
            'path' => $rootDir . '/var/data/banco.sqlite',
        ];
        $fluent = new FluentDriver([
            \Alura\Doctrine\Mapping\AlunoMapping::class,
            \Alura\Doctrine\Mapping\CursoMapping::class,
            \Alura\Doctrine\Mapping\TelefoneMapping::class,
        ]);

        $config = new Configuration();
        $config->setProxyDir($rootDir . '/src/Proxy');
        $config->setProxyNamespace('Alura\Doctrine\Proxy');
        $config->setMetadataDriverImpl($fluent);
        
        return EntityManager::create($connection, $config);
    }
}
