<?php

namespace Alura\Doctrine\Mapping;

use Alura\Doctrine\Entity\Aluno;
use Alura\Doctrine\Entity\Curso;
use LaravelDoctrine\Fluent\EntityMapping;
use LaravelDoctrine\Fluent\Fluent;

class CursoMapping extends EntityMapping
{
    public function mapFor(): string
    {
        return Curso::class;
    }

    public function map(Fluent $builder)
    {
        $builder->increments('id');
        $builder->string('nome');
        $builder
            ->manyToMany(Aluno::class, 'alunos')
            ->inversedBy('cursos');
    }
}
