# Criando uma API de produtos com o Play! Framework

### Tópicos

1. Instalação
2. Rotas, views, modelos e banco de dados
  1. Formulário de produto
  2. Modelo de produto e fábrica de formulários
  3. Ebean e banco de dados MySQL
3. Refactor - Helpers e Bootstrap
  1. Formulários e ajudantes em scala
  2. Bootstrap em uma biblioteca
4. Validação e notificações
  1. Validações no controller
  2. Refactor: ValidadorDeProdutos e Optionals
  3. Flash messages
5. API e filtros de consulta
  1. API com produtos em JSON
  2. Filtro por tipo
  3. Filtro dinâmico e validação
6. Evolutions, usuários e criptografia
  1. Evolutions
  2. Formulário do cliente
  3. Validação e criptografia
7. Email e confirmação de cadastro
  1. Token de confirmação de cadastro
  2. Envio e template de email
  3. Verificação e liberação
8. Autenticação - login e logout
  1. Autenticação e login
  2. Logout
  3. Autenticação real
9. Autenticação da API e registro de acesso
  1. Token da API e segurança do usuário
  2. Autenticação da API no header
  3. Registro de acesso com Actions
10. Área de administração
  1. Listagens e autenticação
  2. Contexto e métodos nas views
