# -*- coding: utf-8 -*-
"""Introdução a Recomendação

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1BRL-xoWxHitEDjn2tU2-KHt3TDjhSalk
"""

import pandas as pd

filmes = pd.read_csv("movies.csv")
filmes.columns = ["filmeId", "titulo", "generos"]
filmes = filmes.set_index("filmeId")
filmes.head()

notas = pd.read_csv("ratings.csv")
notas.columns = ["usuarioId", "filmeId", "nota", "momento"]
notas.head()

notas.describe()

"""# Primeira tentativa de recomendação: heurística de total de votos"""

total_de_votos = notas["filmeId"].value_counts()
total_de_votos.head()

filmes['total_de_votos'] = total_de_votos
filmes.head()

filmes.sort_values("total_de_votos", ascending = False).head(10)

notas_medias = notas.groupby("filmeId").mean()["nota"]
notas_medias.head()

filmes["nota_media"] = notas_medias
filmes.sort_values("total_de_votos", ascending = False).head(10)

"""# Uma segunda heurística: nota média e filtrando votos"""

filmes.sort_values("nota_media", ascending = False).head(10)

filmes.query("total_de_votos >= 10").sort_values("nota_media", ascending = False).head(10)

filmes_com_mais_de_50_votos = filmes.query("total_de_votos >= 50")
filmes_com_mais_de_50_votos.sort_values("nota_media", ascending = False).head(10)

eu_assisti = [1, 21, 19, 10, 11, 7, 2]
filmes.loc[eu_assisti]

aventura_infantil_e_fantasia = filmes_com_mais_de_50_votos.query("generos=='Adventure|Children|Fantasy'")
aventura_infantil_e_fantasia.drop(eu_assisti, errors='ignore').sort_values("nota_media", ascending = False).head(10)

