package br.com.caelum.auron.modelo;

import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

public class SorteadorTest {
	private Participante p1;
	private Participante p2;
	private Participante p3;
	
	private List<Participante> participantes;
	private Sorteio sorteio;

	@Before
	public void setUp() throws Exception {
		p1 = new Participante();
		p1.setNome("Leonardo");
	
		p2 = new Participante();
		p2.setNome("Nico");
		
		p3 = new Participante();
		p3.setNome("Fábio");
		
		participantes = Arrays.asList(p1, p2, p3);
		sorteio = new Sorteio();
	}

	@Test
	public void aQuantidadeDeParesEParticipantesDeveSerAMesma() {
		int quantidadeDeParticipantes = participantes.size();
		
		Sorteador sorteador = new Sorteador(sorteio, participantes);
		sorteador.sortear();
		
		int quantidadeDePares = sorteio.getQuantidadeDePares();
				
		assertTrue(quantidadeDePares == quantidadeDeParticipantes);

	}	
	
	
}
