# -*- coding: utf-8 -*-
"""Introdução a Recomendação

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1BRL-xoWxHitEDjn2tU2-KHt3TDjhSalk
"""

import pandas as pd

filmes = pd.read_csv("movies.csv")
filmes.columns = ["filmeId", "titulo", "generos"]
filmes = filmes.set_index("filmeId")
filmes.head()

notas = pd.read_csv("ratings.csv")
notas.columns = ["usuarioId", "filmeId", "nota", "momento"]
notas.head()

notas.describe()

"""# Primeira tentativa de recomendação: heurística de total de votos"""

total_de_votos = notas["filmeId"].value_counts()
total_de_votos.head()

filmes['total_de_votos'] = total_de_votos
filmes.head()

filmes.sort_values("total_de_votos", ascending = False).head(10)

notas_medias = notas.groupby("filmeId").mean()["nota"]
notas_medias.head()

filmes["nota_media"] = notas_medias
filmes.sort_values("total_de_votos", ascending = False).head(10)

"""# Uma segunda heurística: nota média e filtrando votos"""

filmes.sort_values("nota_media", ascending = False).head(10)

filmes.query("total_de_votos >= 10").sort_values("nota_media", ascending = False).head(10)

filmes_com_mais_de_50_votos = filmes.query("total_de_votos >= 50")
filmes_com_mais_de_50_votos.sort_values("nota_media", ascending = False).head(10)

eu_assisti = [1, 21, 19, 10, 11, 7, 2]
filmes.loc[eu_assisti]

aventura_infantil_e_fantasia = filmes_com_mais_de_50_votos.query("generos=='Adventure|Children|Fantasy'")
aventura_infantil_e_fantasia.drop(eu_assisti, errors='ignore').sort_values("nota_media", ascending = False).head(10)

# Collaborative filtering x Content based filtering

"""# Procurar usuários "similares"

- joão deu nota 4 no filme toy story
- maria deu nota 5 no filme toy story
- paulo deu nota 3 no filme toy story
- joana deu nota 3.5 no filme toy story

x-y ==> distância
"""

import matplotlib.pyplot as plt
plt.plot(4, 4.5, "go")
plt.plot(5, 5, "yo")
plt.legend(["João", "Maria"])
plt.title("Calcular a distância entre dois usuários")

plt.plot([4, 5], [4.5, 4.5], color="b", linestyle="-")
plt.plot([4, 5], [4.5, 5], color="b", linestyle="-")
plt.plot([5, 5], [4.5, 5], color="b", linestyle="-")

import numpy as np

joao = np.array([4, 4.5])
maria = np.array([5, 5])

joao - maria

from math import sqrt

def pitagoras(a,b):
  (delta_x, delta_y) = a - b
  return sqrt(delta_x * delta_x + delta_y * delta_y)

pitagoras(joao, maria)

def pitagoras(a,b):
  return np.linalg.norm(a - b)

pitagoras(joao, maria)

import matplotlib.pyplot as plt
plt.plot(4, 4.5, "go")
plt.plot(5, 5, "yo")
plt.plot(3.5, 4.5, "bo")
plt.legend(["João", "Maria", "Joaquina"])
plt.title("Calcular a distância entre usuários")

joaquina = np.array([3.5, 4.5])

print(pitagoras(joao, maria))
print(pitagoras(joao, joaquina))

def distancia_de_vetores(a,b):
  return np.linalg.norm(a - b)

def notas_do_usuario(usuario):
  notas_do_usuario = notas.query("usuarioId==%d" % usuario)
  notas_do_usuario = notas_do_usuario[["filmeId", "nota"]].set_index("filmeId")
  return notas_do_usuario

usuario1 = notas_do_usuario(1)
usuario4 = notas_do_usuario(4)

usuario1.head()

usuario4.head()

diferencas = usuario1.join(usuario4, lsuffix="_esquerda", rsuffix="_direita").dropna()
distancia_de_vetores(diferencas['nota_esquerda'], diferencas['nota_direita'])

def distancia_de_usuarios(usuario_id1, usuario_id2):
  notas1 = notas_do_usuario(usuario_id1)
  notas2 = notas_do_usuario(usuario_id2)
  diferencas = notas1.join(notas2, lsuffix="_esquerda", rsuffix="_direita").dropna()
  return distancia_de_vetores(diferencas['nota_esquerda'], diferencas['nota_direita'])

distancia_de_usuarios(1,4)

