/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import org.jfugue.theory.Chord;
import org.jfugue.theory.Note;
import org.staccato.PreprocessorFunction;
import org.staccato.StaccatoParserContext;

public class ArpeggiatedChordFunction
implements PreprocessorFunction {
    private static ArpeggiatedChordFunction instance;

    private ArpeggiatedChordFunction() {
    }

    public static ArpeggiatedChordFunction getInstance() {
        if (instance == null) {
            instance = new ArpeggiatedChordFunction();
        }
        return instance;
    }

    @Override
    public String apply(String parameters, StaccatoParserContext context) {
        Chord chord = new Chord(parameters);
        Note[] notes = chord.getNotes();
        double duration = chord.getRoot().getDuration();
        double durationPerNote = duration / (double)notes.length;
        StringBuilder buddy = new StringBuilder();
        for (Note note : notes) {
            buddy.append(Note.getToneString(note.getValue()));
            buddy.append("/");
            buddy.append(durationPerNote);
            buddy.append(" ");
        }
        return buddy.toString().trim();
    }

    @Override
    public String[] getNames() {
        return new String[]{"ARPEGGIATED", "AR"};
    }
}

